//===========================================================================
// @(#) $DwmPath: dwm/mcplex/mcrover/tags/mcrover-0.1.7/classes/include/DwmMcroverAlertVariants.hh 12281 $
// @(#) $Id: DwmMcroverAlertVariants.hh 12281 2023-11-11 16:19:01Z dwm $
//===========================================================================
//  Copyright (c) Daniel W. McRobb 2020
//  All rights reserved.
//
//  Redistribution and use in source and binary forms, with or without
//  modification, are permitted provided that the following conditions
//  are met:
//
//  1. Redistributions of source code must retain the above copyright
//     notice, this list of conditions and the following disclaimer.
//  2. Redistributions in binary form must reproduce the above copyright
//     notice, this list of conditions and the following disclaimer in the
//     documentation and/or other materials provided with the distribution.
//  3. The names of the authors and copyright holders may not be used to
//     endorse or promote products derived from this software without
//     specific prior written permission.
//
//  IN NO EVENT SHALL DANIEL W. MCROBB BE LIABLE TO ANY PARTY FOR
//  DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES,
//  INCLUDING LOST PROFITS, ARISING OUT OF THE USE OF THIS SOFTWARE,
//  EVEN IF DANIEL W. MCROBB HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH
//  DAMAGE.
//
//  THE SOFTWARE PROVIDED HEREIN IS ON AN "AS IS" BASIS, AND
//  DANIEL W. MCROBB HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT,
//  UPDATES, ENHANCEMENTS, OR MODIFICATIONS. DANIEL W. MCROBB MAKES NO
//  REPRESENTATIONS AND EXTENDS NO WARRANTIES OF ANY KIND, EITHER
//  IMPLIED OR EXPRESS, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
//  WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE,
//  OR THAT THE USE OF THIS SOFTWARE WILL NOT INFRINGE ANY PATENT,
//  TRADEMARK OR OTHER RIGHTS.
//===========================================================================

//---------------------------------------------------------------------------
//!  \file DwmMcroverAlertVariants.hh
//!  \author Daniel W. McRobb
//!  \brief DWM_MCROVER_ALERT_VARIANTS macro definition
//---------------------------------------------------------------------------

#ifndef _DWMMCROVERALERTVARIANTS_HH_
#define _DWMMCROVERALERTVARIANTS_HH_

#include <variant>

#include "DwmMcroverBackupAlert.hh"
#include "DwmMcroverBanditAlert.hh"
#include "DwmMcroverCredencePeerAlert.hh"
#include "DwmMcroverDiskAlert.hh"
#include "DwmMcroverDNSAlert.hh"
#include "DwmMcroverFilesystemAlert.hh"
#include "DwmMcroverGuestAlert.hh"
#include "DwmMcroverWebAlert.hh"
#include "DwmMcroverRouteAlert.hh"
#include "DwmMcroverRoverAlert.hh"
#include "DwmMcroverRPCAlert.hh"
#include "DwmMcroverRPC6Alert.hh"
#include "DwmMcroverSMTPAlert.hh"
#include "DwmMcroverTcp4ConnAlert.hh"
#include "DwmMcroverTcp4ConnDeniedAlert.hh"
#include "DwmMcroverTcp6ConnAlert.hh"
#include "DwmMcroverTcp6ConnDeniedAlert.hh"
#include "DwmMcroverWebAppAlert.hh"
#include "DwmMcroverUPSAlert.hh"
#include "DwmMcroverZpoolAlert.hh"

//----------------------------------------------------------------------------
//!  Define all the alert types we can handle.  This is just a convenience
//!  macro.
//----------------------------------------------------------------------------
#define DWM_MCROVER_ALERT_VARIANTS                                           \
    Tcp4ConnAlert, RPCAlert, UPSAlert, SMTPAlert, DNSAlert, ZpoolAlert,      \
    RouteAlert, GuestAlert, BanditAlert, RoverAlert, FilesystemAlert,        \
    WebAlert, Tcp4ConnDeniedAlert, DiskAlert, Tcp6ConnAlert,                 \
    Tcp6ConnDeniedAlert, RPC6Alert, WebAppAlert, CredencePeerAlert,          \
    BackupAlert

#endif  // _DWMMCROVERALERTVARIANTS_HH_
