//===========================================================================
// @(#) $DwmPath: dwm/mcplex/mcrover/tags/mcrover-0.1.7/classes/include/DwmMcroverHTTPAddr.hh 11049 $
// @(#) $Id: DwmMcroverHTTPAddr.hh 11049 2020-08-31 03:40:46Z dwm $
//===========================================================================
//  Copyright (c) Daniel W. McRobb 2020
//  All rights reserved.
//
//  Redistribution and use in source and binary forms, with or without
//  modification, are permitted provided that the following conditions
//  are met:
//
//  1. Redistributions of source code must retain the above copyright
//     notice, this list of conditions and the following disclaimer.
//  2. Redistributions in binary form must reproduce the above copyright
//     notice, this list of conditions and the following disclaimer in the
//     documentation and/or other materials provided with the distribution.
//  3. The names of the authors and copyright holders may not be used to
//     endorse or promote products derived from this software without
//     specific prior written permission.
//
//  IN NO EVENT SHALL DANIEL W. MCROBB BE LIABLE TO ANY PARTY FOR
//  DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES,
//  INCLUDING LOST PROFITS, ARISING OUT OF THE USE OF THIS SOFTWARE,
//  EVEN IF DANIEL W. MCROBB HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH
//  DAMAGE.
//
//  THE SOFTWARE PROVIDED HEREIN IS ON AN "AS IS" BASIS, AND
//  DANIEL W. MCROBB HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT,
//  UPDATES, ENHANCEMENTS, OR MODIFICATIONS. DANIEL W. MCROBB MAKES NO
//  REPRESENTATIONS AND EXTENDS NO WARRANTIES OF ANY KIND, EITHER
//  IMPLIED OR EXPRESS, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
//  WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE,
//  OR THAT THE USE OF THIS SOFTWARE WILL NOT INFRINGE ANY PATENT,
//  TRADEMARK OR OTHER RIGHTS.
//===========================================================================

//---------------------------------------------------------------------------
//!  \file DwmMcroverHTTPAddr.hh
//!  \author Daniel W. McRobb
//!  \brief Dwm::Mcrover::HTTPAddr class declaration
//---------------------------------------------------------------------------

#ifndef _DWMMCROVERHTTPADDR_HH_
#define _DWMMCROVERHTTPADDR_HH_

#include "DwmIpv4Address.hh"
#include "DwmMcroverTcp4DstAddr.hh"

namespace Dwm {

  namespace Mcrover {

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    class HTTPAddr
    {
    public:
      HTTPAddr();
      HTTPAddr(const std::string & name, const Ipv4Address & addr,
               uint16_t port, const std::string & vhost,
               const std::string & page);
      const std::string & Name() const;
      const std::string & Name(const std::string & name);
      const Tcp4DstAddr & Address() const;
      in_addr_t Address(in_addr_t addr);
      uint16_t Port(uint16_t port);
      const std::string & VHost() const;
      const std::string & VHost(const std::string & vhost);
      const std::string & Page() const;
      const std::string & Page(const std::string & page);
      bool operator < (const HTTPAddr & addr) const;
      bool operator == (const HTTPAddr & addr) const;
      
    private:
      Tcp4DstAddr  _addr;
      std::string  _vhost;
      std::string  _page;
    };
    
  }  // namespace Mcrover

}  // namespace Dwm

#endif  // _DWMMCROVERHTTPADDR_HH_
