//===========================================================================
// @(#) $DwmPath: dwm/mcplex/mcrover/tags/mcrover-0.1.7/classes/include/DwmMcroverLocalNetInterface.hh 11959 $
// @(#) $Id: DwmMcroverLocalNetInterface.hh 11959 2022-04-23 15:49:38Z dwm $
//===========================================================================
//  Copyright (c) Daniel W. McRobb 2020
//  All rights reserved.
//
//  Redistribution and use in source and binary forms, with or without
//  modification, are permitted provided that the following conditions
//  are met:
//
//  1. Redistributions of source code must retain the above copyright
//     notice, this list of conditions and the following disclaimer.
//  2. Redistributions in binary form must reproduce the above copyright
//     notice, this list of conditions and the following disclaimer in the
//     documentation and/or other materials provided with the distribution.
//  3. The names of the authors and copyright holders may not be used to
//     endorse or promote products derived from this software without
//     specific prior written permission.
//
//  IN NO EVENT SHALL DANIEL W. MCROBB BE LIABLE TO ANY PARTY FOR
//  DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES,
//  INCLUDING LOST PROFITS, ARISING OUT OF THE USE OF THIS SOFTWARE,
//  EVEN IF DANIEL W. MCROBB HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH
//  DAMAGE.
//
//  THE SOFTWARE PROVIDED HEREIN IS ON AN "AS IS" BASIS, AND
//  DANIEL W. MCROBB HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT,
//  UPDATES, ENHANCEMENTS, OR MODIFICATIONS. DANIEL W. MCROBB MAKES NO
//  REPRESENTATIONS AND EXTENDS NO WARRANTIES OF ANY KIND, EITHER
//  IMPLIED OR EXPRESS, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
//  WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE,
//  OR THAT THE USE OF THIS SOFTWARE WILL NOT INFRINGE ANY PATENT,
//  TRADEMARK OR OTHER RIGHTS.
//===========================================================================

//---------------------------------------------------------------------------
//!  \file DwmMcroverLocalNetInterface.hh
//!  \author Daniel W. McRobb
//!  \brief Dwm::Mcrover::LocalNetInterface class declaration
//---------------------------------------------------------------------------

#ifndef _DWMMCROVERLOCALNETINTERFACE_HH_
#define _DWMMCROVERLOCALNETINTERFACE_HH_


extern "C" {
#ifndef __linux__
  #include <dnet.h>
#else
  #include <dumbnet.h>
#endif
}

#include <string>
#include <vector>

#include "DwmIpv4Prefix.hh"
#include "DwmIpv6Address.hh"

namespace Dwm {

  namespace Mcrover {

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    class LocalNetInterface
    {
    public:
      LocalNetInterface();
      LocalNetInterface(const LocalNetInterface &) = default;
      LocalNetInterface & operator = (const LocalNetInterface &) = default;
      LocalNetInterface(const intf_entry *ifEntry);
      const std::string & Name() const;
      const Ipv4Address & Ipv4Addr() const;
      Ipv4Address Ipv4Netmask() const;
      Ipv4Prefix Ipv4Network() const;
      const std::vector<Ipv4Address> & Ipv4Aliases() const;
      const Ipv6Address & Ipv6Addr() const;
      bool IsUp() const;
      bool IsLoopback() const;
      
    private:
      std::string               _name;
      Ipv4Address               _ipv4Addr;
      uint16_t                  _ipv4AddrBits;
      Ipv6Address               _ipv6Addr;
      bool                      _isUp;
      bool                      _isLoopback;
      std::vector<Ipv4Address>  _ipv4Aliases;
    };
    
  }  // namespace Mcrover

}  // namespace Dwm

#endif  // _DWMMCROVERLOCALNETINTERFACE_HH_
