//===========================================================================
// @(#) $DwmPath: dwm/mcplex/mcrover/tags/mcrover-0.1.7/classes/include/DwmMcroverPackMember.hh 12195 $
// @(#) $Id: DwmMcroverPackMember.hh 12195 2023-06-26 06:20:30Z dwm $
//===========================================================================
//  Copyright (c) Daniel W. McRobb 2020
//  All rights reserved.
//
//  Redistribution and use in source and binary forms, with or without
//  modification, are permitted provided that the following conditions
//  are met:
//
//  1. Redistributions of source code must retain the above copyright
//     notice, this list of conditions and the following disclaimer.
//  2. Redistributions in binary form must reproduce the above copyright
//     notice, this list of conditions and the following disclaimer in the
//     documentation and/or other materials provided with the distribution.
//  3. The names of the authors and copyright holders may not be used to
//     endorse or promote products derived from this software without
//     specific prior written permission.
//
//  IN NO EVENT SHALL DANIEL W. MCROBB BE LIABLE TO ANY PARTY FOR
//  DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES,
//  INCLUDING LOST PROFITS, ARISING OUT OF THE USE OF THIS SOFTWARE,
//  EVEN IF DANIEL W. MCROBB HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH
//  DAMAGE.
//
//  THE SOFTWARE PROVIDED HEREIN IS ON AN "AS IS" BASIS, AND
//  DANIEL W. MCROBB HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT,
//  UPDATES, ENHANCEMENTS, OR MODIFICATIONS. DANIEL W. MCROBB MAKES NO
//  REPRESENTATIONS AND EXTENDS NO WARRANTIES OF ANY KIND, EITHER
//  IMPLIED OR EXPRESS, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
//  WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE,
//  OR THAT THE USE OF THIS SOFTWARE WILL NOT INFRINGE ANY PATENT,
//  TRADEMARK OR OTHER RIGHTS.
//===========================================================================

//---------------------------------------------------------------------------
//!  \file DwmMcroverPackMember.hh
//!  \author Daniel W. McRobb
//!  \brief Dwm::Mcrover::PackMember class declaration
//---------------------------------------------------------------------------

#ifndef _DWMMCROVERPACKMEMBER_HH_
#define _DWMMCROVERPACKMEMBER_HH_

#include "DwmMcroverAlertBowl.hh"
#include "DwmMcroverMcroverdRequest.hh"
#include "DwmMcroverConfig.hh"

namespace Dwm {

  namespace Mcrover {

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    class PackMember
    {
    public:
      PackMember() = default;

      PackMember(const PackMemberConfig & config,
                 const std::string & keyDir = "~/.credence");

      const PackMemberConfig & MemberConfig() const;

      const PackMemberConfig &
      MemberConfig(const PackMemberConfig & memberConfig);

      const std::string & KeyDirectory() const;

      const std::string & KeyDirectory(const std::string & keyDir);

      bool GetMemberAlerts(AlertBowl & alerts,
                           RoverAlert::FailureType & failure) const;

      bool GetPackAlerts(AlertBowl & alerts,
                         RoverAlert::FailureType & failure) const;

      bool GetAllAlerts(AlertBowl & alerts,
                        RoverAlert::FailureType & failure) const;

      bool GetConfig(Config & config) const;
      
    private:
      PackMemberConfig  _config;
      std::string       _keyDirectory;

      bool GetAlerts(AlertBowl & alerts, McroverdRequest whichAlerts,
                     RoverAlert::FailureType & failure) const;
    };
    
  }  // namespace Mcrover

}  // namespace Dwm

#endif  // _DWMMCROVERPACKMEMBER_HH_
