//===========================================================================
// @(#) $DwmPath: dwm/mcplex/mcrover/tags/mcrover-0.1.7/classes/include/DwmMcroverRPCAlert.hh 11886 $
// @(#) $Id: DwmMcroverRPCAlert.hh 11886 2021-04-07 05:16:39Z dwm $
//===========================================================================
//  Copyright (c) Daniel W. McRobb 2020
//  All rights reserved.
//
//  Redistribution and use in source and binary forms, with or without
//  modification, are permitted provided that the following conditions
//  are met:
//
//  1. Redistributions of source code must retain the above copyright
//     notice, this list of conditions and the following disclaimer.
//  2. Redistributions in binary form must reproduce the above copyright
//     notice, this list of conditions and the following disclaimer in the
//     documentation and/or other materials provided with the distribution.
//  3. The names of the authors and copyright holders may not be used to
//     endorse or promote products derived from this software without
//     specific prior written permission.
//
//  IN NO EVENT SHALL DANIEL W. MCROBB BE LIABLE TO ANY PARTY FOR
//  DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES,
//  INCLUDING LOST PROFITS, ARISING OUT OF THE USE OF THIS SOFTWARE,
//  EVEN IF DANIEL W. MCROBB HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH
//  DAMAGE.
//
//  THE SOFTWARE PROVIDED HEREIN IS ON AN "AS IS" BASIS, AND
//  DANIEL W. MCROBB HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT,
//  UPDATES, ENHANCEMENTS, OR MODIFICATIONS. DANIEL W. MCROBB MAKES NO
//  REPRESENTATIONS AND EXTENDS NO WARRANTIES OF ANY KIND, EITHER
//  IMPLIED OR EXPRESS, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
//  WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE,
//  OR THAT THE USE OF THIS SOFTWARE WILL NOT INFRINGE ANY PATENT,
//  TRADEMARK OR OTHER RIGHTS.
//===========================================================================

//---------------------------------------------------------------------------
//!  \file DwmMcroverRPCAlert.hh
//!  \author Daniel W. McRobb
//!  \brief Dwm::Mcrover::RPCAlert class declaration
//---------------------------------------------------------------------------

#ifndef _DWMMCROVERRPCALERT_HH_
#define _DWMMCROVERRPCALERT_HH_

#include "DwmIpv4Address.hh"
#include "DwmMcroverAlertBase.hh"
#include "DwmMcroverRPCProgramId.hh"

namespace Dwm {

  namespace Mcrover {

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    class RPCAlert
      : public AlertBase
    {
    public:
      RPCAlert() = default;

      RPCAlert(const std::string & name, const Ipv4Address & addr,
               const RPCProgramId & program);
      
      const std::string & Name() const;

      const std::string & Name(const std::string & name);
      
      const Ipv4Address & Address() const;

      const Ipv4Address & Address(const Ipv4Address & addr);

      const RPCProgramId & Program() const;

      const RPCProgramId & Program(const RPCProgramId & program);

      bool operator == (const RPCAlert & alert) const
      { return (_data == alert._data); }

      bool operator < (const RPCAlert & alert) const
      { return (_data < alert._data); }
      
      uint8_t Priority() const override { return 3; }

      nlohmann::json ToJson() const override;

      bool FromJson(const nlohmann::json & j) override;
      
      std::string DisplayString() const override;

      std::istream & Read(std::istream & is) override;
      ssize_t Read(int fd) override;
      size_t Read(FILE * f) override;
      std::ostream & Write(std::ostream & os) const override;
      ssize_t Write(int fd) const override;
      size_t Write(FILE *f) const override;
      uint64_t StreamedLength() const override;
      
    private:
      // address, program, name
      std::tuple<Ipv4Address,RPCProgramId,std::string> _data;
    };
    
  }  // namespace Mcrover

}  // namespace Dwm

#endif  // _DWMMCROVERRPCALERT_HH_
