//===========================================================================
// @(#) $DwmPath: dwm/mcplex/mcrover/tags/mcrover-0.1.7/classes/include/DwmMcroverRPCProgramId.hh 11886 $
// @(#) $Id: DwmMcroverRPCProgramId.hh 11886 2021-04-07 05:16:39Z dwm $
//===========================================================================
//  Copyright (c) Daniel W. McRobb 2020
//  All rights reserved.
//
//  Redistribution and use in source and binary forms, with or without
//  modification, are permitted provided that the following conditions
//  are met:
//
//  1. Redistributions of source code must retain the above copyright
//     notice, this list of conditions and the following disclaimer.
//  2. Redistributions in binary form must reproduce the above copyright
//     notice, this list of conditions and the following disclaimer in the
//     documentation and/or other materials provided with the distribution.
//  3. The names of the authors and copyright holders may not be used to
//     endorse or promote products derived from this software without
//     specific prior written permission.
//
//  IN NO EVENT SHALL DANIEL W. MCROBB BE LIABLE TO ANY PARTY FOR
//  DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES,
//  INCLUDING LOST PROFITS, ARISING OUT OF THE USE OF THIS SOFTWARE,
//  EVEN IF DANIEL W. MCROBB HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH
//  DAMAGE.
//
//  THE SOFTWARE PROVIDED HEREIN IS ON AN "AS IS" BASIS, AND
//  DANIEL W. MCROBB HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT,
//  UPDATES, ENHANCEMENTS, OR MODIFICATIONS. DANIEL W. MCROBB MAKES NO
//  REPRESENTATIONS AND EXTENDS NO WARRANTIES OF ANY KIND, EITHER
//  IMPLIED OR EXPRESS, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
//  WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE,
//  OR THAT THE USE OF THIS SOFTWARE WILL NOT INFRINGE ANY PATENT,
//  TRADEMARK OR OTHER RIGHTS.
//===========================================================================

//---------------------------------------------------------------------------
//!  \file DwmMcroverRPCProgramId.hh
//!  \author Daniel W. McRobb
//!  \brief Dwm::Mcrover::RPCProgramId class declaration
//---------------------------------------------------------------------------

#ifndef _DWMMCROVERRPCPROGRAMID_HH_
#define _DWMMCROVERRPCPROGRAMID_HH_

#include <iostream>
#include <string>

#include <nlohmann/json.hpp>

#include "DwmDescriptorIOCapable.hh"
#include "DwmFileIOCapable.hh"
#include "DwmStreamIOCapable.hh"
#include "DwmStreamedLengthCapable.hh"

namespace Dwm {

  namespace Mcrover {

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    class RPCProgramId
      : public DescriptorIOCapable, public FileIOCapable,
        public StreamIOCapable, public StreamedLengthCapable
    {
    public:
      //----------------------------------------------------------------------
      //!  
      //----------------------------------------------------------------------
      RPCProgramId() = default;

      //----------------------------------------------------------------------
      //!  
      //----------------------------------------------------------------------
      RPCProgramId(const nlohmann::json & j);
      
      //----------------------------------------------------------------------
      //!  
      //----------------------------------------------------------------------
      RPCProgramId(const std::string & progName, unsigned long protocol,
                   unsigned long version);
      
      //----------------------------------------------------------------------
      //!  
      //----------------------------------------------------------------------
      RPCProgramId(unsigned long progNum, unsigned long protocol,
                   unsigned long version);
  
      //----------------------------------------------------------------------
      //!  
      //----------------------------------------------------------------------
      RPCProgramId(unsigned long progNum, const std::string & progName,
                   unsigned long protocol, unsigned long version);

      //----------------------------------------------------------------------
      //!  
      //----------------------------------------------------------------------
      uint32_t Number() const;

      uint32_t Number(uint32_t num);

      //----------------------------------------------------------------------
      //!  
      //----------------------------------------------------------------------
      std::string Name() const;

      std::string Name(const std::string & name);

      //----------------------------------------------------------------------
      //!  
      //----------------------------------------------------------------------
      uint32_t Protocol() const;

      uint32_t Protocol(uint32_t protocol);

      //----------------------------------------------------------------------
      //!  
      //----------------------------------------------------------------------
      uint32_t Version() const;

      uint32_t Version(uint32_t version);

      //----------------------------------------------------------------------
      //!  
      //----------------------------------------------------------------------
      bool operator < (const RPCProgramId & rpcpm) const;
      
      //----------------------------------------------------------------------
      //!  
      //----------------------------------------------------------------------
      bool operator == (const RPCProgramId & rpcpm) const;
      
      //----------------------------------------------------------------------
      //!  
      //----------------------------------------------------------------------
      friend std::ostream & operator << (std::ostream & os,
                                         const RPCProgramId & rpcpm);

      std::istream & Read(std::istream & is) override;
      ssize_t Read(int fd) override;
      size_t Read(FILE * f) override;
      std::ostream & Write(std::ostream & os) const override;
      ssize_t Write(int fd) const override;
      size_t Write(FILE *f) const override;
      uint64_t StreamedLength() const override;
      nlohmann::json ToJson() const;
      bool FromJson(const nlohmann::json & j);

    private:
      uint32_t     _progNum;
      uint32_t     _protocol;
      uint32_t     _version;
      std::string  _progName;
    };
    
  }  // namespace Mcrover
  
}  // namespace Dwm

#endif  // _DWMMCROVERRPCPROGRAMID_HH_
