//===========================================================================
// @(#) $DwmPath: dwm/mcplex/mcrover/tags/mcrover-0.1.7/classes/include/DwmMcroverRPCTarget.hh 11047 $
// @(#) $Id: DwmMcroverRPCTarget.hh 11047 2020-08-31 03:21:05Z dwm $
//===========================================================================
//  Copyright (c) Daniel W. McRobb 2020
//  All rights reserved.
//
//  Redistribution and use in source and binary forms, with or without
//  modification, are permitted provided that the following conditions
//  are met:
//
//  1. Redistributions of source code must retain the above copyright
//     notice, this list of conditions and the following disclaimer.
//  2. Redistributions in binary form must reproduce the above copyright
//     notice, this list of conditions and the following disclaimer in the
//     documentation and/or other materials provided with the distribution.
//  3. The names of the authors and copyright holders may not be used to
//     endorse or promote products derived from this software without
//     specific prior written permission.
//
//  IN NO EVENT SHALL DANIEL W. MCROBB BE LIABLE TO ANY PARTY FOR
//  DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES,
//  INCLUDING LOST PROFITS, ARISING OUT OF THE USE OF THIS SOFTWARE,
//  EVEN IF DANIEL W. MCROBB HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH
//  DAMAGE.
//
//  THE SOFTWARE PROVIDED HEREIN IS ON AN "AS IS" BASIS, AND
//  DANIEL W. MCROBB HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT,
//  UPDATES, ENHANCEMENTS, OR MODIFICATIONS. DANIEL W. MCROBB MAKES NO
//  REPRESENTATIONS AND EXTENDS NO WARRANTIES OF ANY KIND, EITHER
//  IMPLIED OR EXPRESS, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
//  WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE,
//  OR THAT THE USE OF THIS SOFTWARE WILL NOT INFRINGE ANY PATENT,
//  TRADEMARK OR OTHER RIGHTS.
//===========================================================================

//---------------------------------------------------------------------------
//!  \file DwmMcroverRPCTarget.hh
//!  \author Daniel W. McRobb
//!  \brief Dwm::Mcrover::RPCTarget class declaration
//---------------------------------------------------------------------------

#ifndef _DWMMCROVERRPCTARGET_HH_
#define _DWMMCROVERRPCTARGET_HH_

#include <chrono>
#include <set>

#include <nlohmann/json.hpp>

#include "DwmIpv4Address.hh"
#include "DwmMcroverTargetHostConfig.hh"

namespace Dwm {

  namespace Mcrover {

    //------------------------------------------------------------------------
    //!  Encapsulates a single RPC target (i.e. a host running RPC services
    //!  of interest).
    //------------------------------------------------------------------------
    class RPCTarget
    {
    public:
      //----------------------------------------------------------------------
      //!  Construct from the given configuration @c hostConfig.
      //----------------------------------------------------------------------
      RPCTarget(const TargetHostConfig & hostConfig);
      
      //----------------------------------------------------------------------
      //!  Returns the target's name.
      //----------------------------------------------------------------------
      const std::string & Name() const;
      
      //----------------------------------------------------------------------
      //!  Returns the target's IPv4 address.
      //----------------------------------------------------------------------
      const Dwm::Ipv4Address & Address() const;
      
      //----------------------------------------------------------------------
      //!  Returns the set of RPC programs we expect to be running on the
      //!  target.
      //----------------------------------------------------------------------
      const std::set<RPCProgramId> & ExpectedPrograms() const;
      
      //----------------------------------------------------------------------
      //!  Tests the target for all expected RPC programs.  Returns true if
      //!  all expected RPC programs were accessible.  Else populates
      //!  @c failedPrograms with all programs that were unreachable and
      //!  returns false.
      //----------------------------------------------------------------------
      bool Test(std::set<RPCProgramId> & failedPrograms) const;
      
      //----------------------------------------------------------------------
      //!  operator <
      //----------------------------------------------------------------------
      bool operator < (const RPCTarget & target) const;
      
      //----------------------------------------------------------------------
      //!  operator ==
      //----------------------------------------------------------------------
      bool operator == (const RPCTarget & target) const;
      
    private:
      std::string             _name;
      Dwm::Ipv4Address        _addr;
      std::set<RPCProgramId>  _expectedPrograms;

      bool PortmapperReachable(const Dwm::Ipv4Address & addr,
                               std::chrono::milliseconds timeOut =
                               std::chrono::milliseconds(2000)) const;
      
      bool Ping(const RPCProgramId & prog) const;
    };
    
  }  // namespace Mcrover

}  // namespace Dwm

#endif  // _DWMMCROVERRPCTARGET_HH_
