//===========================================================================
// @(#) $DwmPath: dwm/mcplex/mcrover/tags/mcrover-0.1.7/classes/include/DwmMcroverTargetHostConfig.hh 12169 $
// @(#) $Id: DwmMcroverTargetHostConfig.hh 12169 2023-06-19 21:13:22Z dwm $
//===========================================================================
//  Copyright (c) Daniel W. McRobb 2020, 2023
//  All rights reserved.
//
//  Redistribution and use in source and binary forms, with or without
//  modification, are permitted provided that the following conditions
//  are met:
//
//  1. Redistributions of source code must retain the above copyright
//     notice, this list of conditions and the following disclaimer.
//  2. Redistributions in binary form must reproduce the above copyright
//     notice, this list of conditions and the following disclaimer in the
//     documentation and/or other materials provided with the distribution.
//  3. The names of the authors and copyright holders may not be used to
//     endorse or promote products derived from this software without
//     specific prior written permission.
//
//  IN NO EVENT SHALL DANIEL W. MCROBB BE LIABLE TO ANY PARTY FOR
//  DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES,
//  INCLUDING LOST PROFITS, ARISING OUT OF THE USE OF THIS SOFTWARE,
//  EVEN IF DANIEL W. MCROBB HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH
//  DAMAGE.
//
//  THE SOFTWARE PROVIDED HEREIN IS ON AN "AS IS" BASIS, AND
//  DANIEL W. MCROBB HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT,
//  UPDATES, ENHANCEMENTS, OR MODIFICATIONS. DANIEL W. MCROBB MAKES NO
//  REPRESENTATIONS AND EXTENDS NO WARRANTIES OF ANY KIND, EITHER
//  IMPLIED OR EXPRESS, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
//  WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE,
//  OR THAT THE USE OF THIS SOFTWARE WILL NOT INFRINGE ANY PATENT,
//  TRADEMARK OR OTHER RIGHTS.
//===========================================================================

//---------------------------------------------------------------------------
//!  \file DwmMcroverTargetHostConfig.hh
//!  \author Daniel W. McRobb
//!  \brief Dwm::Mcrover::TargetHostConfig class declaration
//---------------------------------------------------------------------------

#ifndef _DWMMCROVERTARGETHOSTCONFIG_HH_
#define _DWMMCROVERTARGETHOSTCONFIG_HH_

#include <cstdint>
#include <set>
#include <string>
#include <vector>

#include "DwmIpv6Address.hh"
#include "DwmDnsMessageQuestion.hh"
#include "DwmMcroverHTTPAddr.hh"
#include "DwmMcroverRPCProgramId.hh"
#include "DwmMcroverTcpDstAddr.hh"
#include "DwmMcroverWebTarget.hh"
#include "DwmMcroverWebAppTarget.hh"

namespace Dwm {

  namespace Mcrover {

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    class TargetHostConfig
    {
    public:
      //----------------------------------------------------------------------
      //!  
      //----------------------------------------------------------------------
      TargetHostConfig();
      
      //----------------------------------------------------------------------
      //!  
      //----------------------------------------------------------------------
      const std::string & Name() const;

      //----------------------------------------------------------------------
      //!  
      //----------------------------------------------------------------------
      const std::string & Name(const std::string & name);

      //----------------------------------------------------------------------
      //!  
      //----------------------------------------------------------------------
      const Ipv4Address & Address() const;

      //----------------------------------------------------------------------
      //!  
      //----------------------------------------------------------------------
      const Ipv4Address & Address(const Ipv4Address & addr);

      //----------------------------------------------------------------------
      //!  
      //----------------------------------------------------------------------
      const Ipv6Address & Address6() const;

      //----------------------------------------------------------------------
      //!  
      //----------------------------------------------------------------------
      const Ipv6Address & Address6(const Ipv6Address & addr);
      
      //----------------------------------------------------------------------
      //!  
      //----------------------------------------------------------------------
      Ipv4Address PreferredAddress() const;
      
      //----------------------------------------------------------------------
      //!  
      //----------------------------------------------------------------------
      const std::vector<uint16_t> & TCP4Ports() const;

      //----------------------------------------------------------------------
      //!  
      //----------------------------------------------------------------------
      const std::vector<uint16_t> &
      TCP4Ports(const std::vector<uint16_t> & ports);

      //----------------------------------------------------------------------
      //!  
      //----------------------------------------------------------------------
      const std::vector<uint16_t> & TCP6Ports() const;

      //----------------------------------------------------------------------
      //!  
      //----------------------------------------------------------------------
      const std::vector<uint16_t> &
      TCP6Ports(const std::vector<uint16_t> & ports);
      
      //----------------------------------------------------------------------
      //!  
      //----------------------------------------------------------------------
      const std::vector<uint16_t> & TCP4PortsDenied() const;

      //----------------------------------------------------------------------
      //!  
      //----------------------------------------------------------------------
      const std::vector<uint16_t> &
      TCP4PortsDenied(const std::vector<uint16_t> & ports);

      //----------------------------------------------------------------------
      //!  
      //----------------------------------------------------------------------
      const std::vector<uint16_t> & TCP6PortsDenied() const;

      //----------------------------------------------------------------------
      //!  
      //----------------------------------------------------------------------
      const std::vector<uint16_t> &
      TCP6PortsDenied(const std::vector<uint16_t> & ports);
      
      //----------------------------------------------------------------------
      //!  
      //----------------------------------------------------------------------
      const std::set<RPCProgramId> & ExpectedPrograms() const;

      //----------------------------------------------------------------------
      //!  
      //----------------------------------------------------------------------
      const std::set<RPCProgramId> &
      ExpectedPrograms(const std::vector<RPCProgramId> & progs);

      //----------------------------------------------------------------------
      //!  
      //----------------------------------------------------------------------
      const std::set<RPCProgramId> & Expected6Programs() const;

      //----------------------------------------------------------------------
      //!  
      //----------------------------------------------------------------------
      const std::set<RPCProgramId> &
      Expected6Programs(const std::vector<RPCProgramId> & progs);
      
      //----------------------------------------------------------------------
      //!  
      //----------------------------------------------------------------------
      const std::vector<uint16_t> & SMTPPorts() const;

      //----------------------------------------------------------------------
      //!  
      //----------------------------------------------------------------------
      const std::vector<uint16_t> &
      SMTPPorts(const std::vector<uint16_t> & ports);

      //----------------------------------------------------------------------
      //!  
      //----------------------------------------------------------------------
      const std::vector<uint16_t> & SMTP6Ports() const;

      //----------------------------------------------------------------------
      //!  
      //----------------------------------------------------------------------
      const std::vector<uint16_t> &
      SMTP6Ports(const std::vector<uint16_t> & ports);
      
      //----------------------------------------------------------------------
      //!  
      //----------------------------------------------------------------------
      const std::vector<std::string> & UPS() const;

      //----------------------------------------------------------------------
      //!  
      //----------------------------------------------------------------------
      const std::vector<std::string> &
      UPS(const std::vector<std::string> & upses);
      
      //----------------------------------------------------------------------
      //!  
      //----------------------------------------------------------------------
      const std::vector<WebTarget> & WebTargets() const;

      //----------------------------------------------------------------------
      //!  
      //----------------------------------------------------------------------
      const std::vector<WebTarget> &
      WebTargets(const std::vector<WebTarget> & targets);

      //----------------------------------------------------------------------
      //!  
      //----------------------------------------------------------------------
      const std::vector<WebAppTarget> & WebAppTargets() const;

      //----------------------------------------------------------------------
      //!  
      //----------------------------------------------------------------------
      const std::vector<WebAppTarget> &
      WebAppTargets(const std::vector<WebAppTarget> & targets);
      
      //----------------------------------------------------------------------
      //!  
      //----------------------------------------------------------------------
      const std::vector<Dns::MessageQuestion> & DNSResolve() const;

      //----------------------------------------------------------------------
      //!  
      //----------------------------------------------------------------------
      const std::vector<Dns::MessageQuestion> &
      DNSResolve(const std::vector<Dns::MessageQuestion> & resolveList);

      //----------------------------------------------------------------------
      //!  
      //----------------------------------------------------------------------
      const std::vector<TcpDstAddr> & CredencePeerTargets() const;

      //----------------------------------------------------------------------
      //!  
      //----------------------------------------------------------------------
      const std::vector<TcpDstAddr> &
      CredencePeerTargets(const std::vector<TcpDstAddr> & targets);

      //----------------------------------------------------------------------
      //!  
      //----------------------------------------------------------------------
      friend std::ostream &
      operator << (std::ostream & os, const TargetHostConfig & cfg);

      //----------------------------------------------------------------------
      //!  
      //----------------------------------------------------------------------
      nlohmann::json ToJson() const;

      //----------------------------------------------------------------------
      //!  
      //----------------------------------------------------------------------
      bool FromJson(const nlohmann::json & j);

      //----------------------------------------------------------------------
      //!  
      //----------------------------------------------------------------------
      void Clear();
      
    private:
      std::string                        _name;
      Ipv4Address                        _address;
      Ipv6Address                        _address6;
      std::vector<uint16_t>              _tcp4Ports;
      std::vector<uint16_t>              _tcp6Ports;
      std::vector<uint16_t>              _tcp4PortsDenied;
      std::vector<uint16_t>              _tcp6PortsDenied;
      std::set<RPCProgramId>             _expectedPrograms;
      std::set<RPCProgramId>             _expected6Programs;
      std::vector<uint16_t>              _smtpPorts;
      std::vector<uint16_t>              _smtp6Ports;
      std::vector<std::string>           _ups;
      std::vector<WebTarget>             _webTargets;
      std::vector<WebAppTarget>          _webAppTargets;
      std::vector<Dns::MessageQuestion>  _dnsResolve;
      std::vector<TcpDstAddr>            _credencePeerTargets;
    };
    
  }  // namespace Mcrover

}  // namespace Dwm

#endif  // _DWMMCROVERTARGETHOSTCONFIG_HH_
