//===========================================================================
// @(#) $DwmPath: dwm/mcplex/mcrover/tags/mcrover-0.1.7/classes/include/DwmMcroverTcp4ConnAlert.hh 11886 $
// @(#) $Id: DwmMcroverTcp4ConnAlert.hh 11886 2021-04-07 05:16:39Z dwm $
//===========================================================================
//  Copyright (c) Daniel W. McRobb 2020
//  All rights reserved.
//
//  Redistribution and use in source and binary forms, with or without
//  modification, are permitted provided that the following conditions
//  are met:
//
//  1. Redistributions of source code must retain the above copyright
//     notice, this list of conditions and the following disclaimer.
//  2. Redistributions in binary form must reproduce the above copyright
//     notice, this list of conditions and the following disclaimer in the
//     documentation and/or other materials provided with the distribution.
//  3. The names of the authors and copyright holders may not be used to
//     endorse or promote products derived from this software without
//     specific prior written permission.
//
//  IN NO EVENT SHALL DANIEL W. MCROBB BE LIABLE TO ANY PARTY FOR
//  DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES,
//  INCLUDING LOST PROFITS, ARISING OUT OF THE USE OF THIS SOFTWARE,
//  EVEN IF DANIEL W. MCROBB HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH
//  DAMAGE.
//
//  THE SOFTWARE PROVIDED HEREIN IS ON AN "AS IS" BASIS, AND
//  DANIEL W. MCROBB HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT,
//  UPDATES, ENHANCEMENTS, OR MODIFICATIONS. DANIEL W. MCROBB MAKES NO
//  REPRESENTATIONS AND EXTENDS NO WARRANTIES OF ANY KIND, EITHER
//  IMPLIED OR EXPRESS, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
//  WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE,
//  OR THAT THE USE OF THIS SOFTWARE WILL NOT INFRINGE ANY PATENT,
//  TRADEMARK OR OTHER RIGHTS.
//===========================================================================

//---------------------------------------------------------------------------
//!  \file DwmMcroverTcp4ConnAlert.hh
//!  \author Daniel W. McRobb
//!  \brief Dwm::Mcrover::Tcp4ConnAlert class declaration
//---------------------------------------------------------------------------

#ifndef _DWMMCROVERTCP4CONNALERT_HH_
#define _DWMMCROVERTCP4CONNALERT_HH_

#include "DwmMcroverAlertBase.hh"
#include "DwmMcroverTcp4DstAddr.hh"

namespace Dwm {

  namespace Mcrover {

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    class Tcp4ConnAlert
      : public AlertBase
    {
    public:
      Tcp4ConnAlert();
      Tcp4ConnAlert(const Tcp4DstAddr & dst);
      
      const Tcp4DstAddr & Destination() const;
      const Tcp4DstAddr & Destination(const Tcp4DstAddr & dst);
      
      uint8_t Priority() const override { return 2; }
      virtual std::string DisplayString() const override;
      nlohmann::json ToJson() const override;
      bool FromJson(const nlohmann::json & j) override;

      virtual std::istream & Read(std::istream & is) override;
      virtual ssize_t Read(int fd) override;
      virtual size_t Read(FILE * f) override;
      virtual std::ostream & Write(std::ostream & os) const override;
      virtual ssize_t Write(int fd) const override;
      virtual size_t Write(FILE *f) const override;
      virtual uint64_t StreamedLength() const override;

      bool operator == (const Tcp4ConnAlert & alert) const;
      bool operator < (const Tcp4ConnAlert & alert) const;
      
    protected:
      Tcp4DstAddr  _dstAddr;
    };
    
  }  // namespace Mcrover

}  // namespace Dwm

#endif  // _DWMMCROVERTCP4CONNALERT_HH_
