//===========================================================================
// @(#) $DwmPath: dwm/mcplex/mcrover/tags/mcrover-0.1.7/classes/include/DwmMcroverUPSTarget.hh 11047 $
// @(#) $Id: DwmMcroverUPSTarget.hh 11047 2020-08-31 03:21:05Z dwm $
//===========================================================================
//  Copyright (c) Daniel W. McRobb 2020
//  All rights reserved.
//
//  Redistribution and use in source and binary forms, with or without
//  modification, are permitted provided that the following conditions
//  are met:
//
//  1. Redistributions of source code must retain the above copyright
//     notice, this list of conditions and the following disclaimer.
//  2. Redistributions in binary form must reproduce the above copyright
//     notice, this list of conditions and the following disclaimer in the
//     documentation and/or other materials provided with the distribution.
//  3. The names of the authors and copyright holders may not be used to
//     endorse or promote products derived from this software without
//     specific prior written permission.
//
//  IN NO EVENT SHALL DANIEL W. MCROBB BE LIABLE TO ANY PARTY FOR
//  DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES,
//  INCLUDING LOST PROFITS, ARISING OUT OF THE USE OF THIS SOFTWARE,
//  EVEN IF DANIEL W. MCROBB HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH
//  DAMAGE.
//
//  THE SOFTWARE PROVIDED HEREIN IS ON AN "AS IS" BASIS, AND
//  DANIEL W. MCROBB HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT,
//  UPDATES, ENHANCEMENTS, OR MODIFICATIONS. DANIEL W. MCROBB MAKES NO
//  REPRESENTATIONS AND EXTENDS NO WARRANTIES OF ANY KIND, EITHER
//  IMPLIED OR EXPRESS, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
//  WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE,
//  OR THAT THE USE OF THIS SOFTWARE WILL NOT INFRINGE ANY PATENT,
//  TRADEMARK OR OTHER RIGHTS.
//===========================================================================

//---------------------------------------------------------------------------
//!  \file DwmMcroverUPSTarget.hh
//!  \author Daniel W. McRobb
//!  \brief Dwm::Mcrover::UPSTarget class declaration
//---------------------------------------------------------------------------

#ifndef _DWMMCROVERUPSTARGET_HH_
#define _DWMMCROVERUPSTARGET_HH_

#include <set>
#include <map>
#include <string>

#include "DwmMcroverTargetHostConfig.hh"
#include "DwmMcroverUPSStatus.hh"

namespace Dwm {

  namespace Mcrover {

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    class UPSTarget
    {
    public:
      UPSTarget(const TargetHostConfig & hostConfig);
      const std::string & Name() const;
      const Ipv4Address & Address() const;
      bool Test(std::map<std::string,UPSStatus> & result) const;

      bool operator < (const UPSTarget & target) const;
      
    private:
      std::string            _name;
      Dwm::Ipv4Address       _addr;
      std::set<std::string>  _upses;
    };
    
  }  // namespace Mcrover

}  // namespace Dwm

#endif  // _DWMMCROVERUPSTARGET_HH_
