//===========================================================================
// @(#) $DwmPath: dwm/mcplex/mcrover/tags/mcrover-0.1.7/classes/src/DwmMcroverAlertOrigin.cc 11959 $
// @(#) $Id: DwmMcroverAlertOrigin.cc 11959 2022-04-23 15:49:38Z dwm $
//===========================================================================
//  Copyright (c) Daniel W. McRobb 2020
//  All rights reserved.
//
//  Redistribution and use in source and binary forms, with or without
//  modification, are permitted provided that the following conditions
//  are met:
//
//  1. Redistributions of source code must retain the above copyright
//     notice, this list of conditions and the following disclaimer.
//  2. Redistributions in binary form must reproduce the above copyright
//     notice, this list of conditions and the following disclaimer in the
//     documentation and/or other materials provided with the distribution.
//  3. The names of the authors and copyright holders may not be used to
//     endorse or promote products derived from this software without
//     specific prior written permission.
//
//  IN NO EVENT SHALL DANIEL W. MCROBB BE LIABLE TO ANY PARTY FOR
//  DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES,
//  INCLUDING LOST PROFITS, ARISING OUT OF THE USE OF THIS SOFTWARE,
//  EVEN IF DANIEL W. MCROBB HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH
//  DAMAGE.
//
//  THE SOFTWARE PROVIDED HEREIN IS ON AN "AS IS" BASIS, AND
//  DANIEL W. MCROBB HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT,
//  UPDATES, ENHANCEMENTS, OR MODIFICATIONS. DANIEL W. MCROBB MAKES NO
//  REPRESENTATIONS AND EXTENDS NO WARRANTIES OF ANY KIND, EITHER
//  IMPLIED OR EXPRESS, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
//  WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE,
//  OR THAT THE USE OF THIS SOFTWARE WILL NOT INFRINGE ANY PATENT,
//  TRADEMARK OR OTHER RIGHTS.
//===========================================================================

//---------------------------------------------------------------------------
//!  \file DwmMcroverAlertOrigin.cc
//!  \author Daniel W. McRobb
//!  \brief Dwm::Mcrover::AlertOrigin class implementation
//---------------------------------------------------------------------------

#include "DwmDescriptorIO.hh"
#include "DwmFileIO.hh"
#include "DwmIOUtils.hh"
#include "DwmStreamIO.hh"
#include "DwmSvnTag.hh"
#include "DwmMcroverAlertOrigin.hh"

static const Dwm::SvnTag svntag("@(#) $DwmPath: dwm/mcplex/mcrover/tags/mcrover-0.1.7/classes/src/DwmMcroverAlertOrigin.cc 11959 $");

namespace Dwm {

  namespace Mcrover {

#if 0
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    AlertOrigin::AlertOrigin(const std::string & packName,
                             const Ipv4Address & memberAddr)
        : _data({packName, memberAddr})
    {}
#else
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    AlertOrigin::AlertOrigin(const std::string & packName,
                             const IpAddress & memberAddr)
        : _data({packName, memberAddr})
    {}
#endif
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    const std::string & AlertOrigin::PackName() const
    {
      return std::get<0>(_data);
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    const std::string & AlertOrigin::PackName(const std::string & packName)
    {
      std::get<0>(_data) = packName;
      return std::get<0>(_data);
    }

#if 0
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    const Ipv4Address & AlertOrigin::MemberAddress() const
    {
      return std::get<1>(_data);
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    const Ipv4Address &
    AlertOrigin::MemberAddress(const Ipv4Address & memberAddr)
    {
      std::get<1>(_data) = memberAddr;
      return std::get<1>(_data);
    }
#else
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    const IpAddress & AlertOrigin::MemberAddress() const
    {
      return std::get<1>(_data);
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    const IpAddress &
    AlertOrigin::MemberAddress(const IpAddress & memberAddr)
    {
      std::get<1>(_data) = memberAddr;
      return std::get<1>(_data);
    }
#endif
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    std::istream & AlertOrigin::Read(std::istream & is)
    {
      return Dwm::StreamIO::Read(is, _data);
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    ssize_t AlertOrigin::Read(int fd)
    {
      return Dwm::DescriptorIO::Read(fd, _data);
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    size_t AlertOrigin::Read(FILE * f)
    {
      return Dwm::FileIO::Read(f, _data);
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    std::ostream & AlertOrigin::Write(std::ostream & os) const
    {
      return Dwm::StreamIO::Write(os, _data);
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    ssize_t AlertOrigin::Write(int fd) const
    {
      return Dwm::DescriptorIO::Write(fd, _data);
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    size_t AlertOrigin::Write(FILE *f) const
    {
      return Dwm::FileIO::Write(f, _data);
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    uint64_t AlertOrigin::StreamedLength() const
    {
      return Dwm::IOUtils::StreamedLength(_data);
    }
    
  }  // namespace Mcrover
  
}  // namespace Dwm
