//===========================================================================
// @(#) $DwmPath: dwm/mcplex/mcrover/tags/mcrover-0.1.7/classes/src/DwmMcroverDNSAlert.cc 11886 $
// @(#) $Id: DwmMcroverDNSAlert.cc 11886 2021-04-07 05:16:39Z dwm $
//===========================================================================
//  Copyright (c) Daniel W. McRobb 2020
//  All rights reserved.
//
//  Redistribution and use in source and binary forms, with or without
//  modification, are permitted provided that the following conditions
//  are met:
//
//  1. Redistributions of source code must retain the above copyright
//     notice, this list of conditions and the following disclaimer.
//  2. Redistributions in binary form must reproduce the above copyright
//     notice, this list of conditions and the following disclaimer in the
//     documentation and/or other materials provided with the distribution.
//  3. The names of the authors and copyright holders may not be used to
//     endorse or promote products derived from this software without
//     specific prior written permission.
//
//  IN NO EVENT SHALL DANIEL W. MCROBB BE LIABLE TO ANY PARTY FOR
//  DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES,
//  INCLUDING LOST PROFITS, ARISING OUT OF THE USE OF THIS SOFTWARE,
//  EVEN IF DANIEL W. MCROBB HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH
//  DAMAGE.
//
//  THE SOFTWARE PROVIDED HEREIN IS ON AN "AS IS" BASIS, AND
//  DANIEL W. MCROBB HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT,
//  UPDATES, ENHANCEMENTS, OR MODIFICATIONS. DANIEL W. MCROBB MAKES NO
//  REPRESENTATIONS AND EXTENDS NO WARRANTIES OF ANY KIND, EITHER
//  IMPLIED OR EXPRESS, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
//  WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE,
//  OR THAT THE USE OF THIS SOFTWARE WILL NOT INFRINGE ANY PATENT,
//  TRADEMARK OR OTHER RIGHTS.
//===========================================================================

//---------------------------------------------------------------------------
//!  \file DwmMcroverDNSAlert.cc
//!  \author Daniel W. McRobb
//!  \brief Dwm::Mcrover::DNSAlert class implementation
//---------------------------------------------------------------------------

#include "DwmDescriptorIO.hh"
#include "DwmFileIO.hh"
#include "DwmIOUtils.hh"
#include "DwmStreamIO.hh"
#include "DwmIpv4Address.hh"
#include "DwmSvnTag.hh"
#include "DwmDnsMessageQuestion.hh"
#include "DwmMcroverDNSAlert.hh"
#include "DwmMcroverUtils.hh"

static const Dwm::SvnTag svntag("@(#) $DwmPath: dwm/mcplex/mcrover/tags/mcrover-0.1.7/classes/src/DwmMcroverDNSAlert.cc 11886 $");

namespace Dwm {

  namespace Mcrover {

    using namespace std;
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    DNSAlert::DNSAlert()
        : _data()
    {}
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    DNSAlert::DNSAlert(const Ipv4Address & server,
                       const string & question,
                       uint16_t questionType)
        : _data({server, question, questionType})
    {}
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    const Ipv4Address & DNSAlert::Server() const
    {
      return std::get<0>(_data);
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    const Ipv4Address & DNSAlert::Server(const Ipv4Address & server)
    {
      std::get<0>(_data) = server;
      return std::get<0>(_data);
    }

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    const string & DNSAlert::Question() const
    {
      return std::get<1>(_data);
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    const string & DNSAlert::Question(const string & question)
    {
      std::get<1>(_data) = question;
      return std::get<1>(_data);
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    uint16_t DNSAlert::QuestionType() const
    {
      return std::get<2>(_data);
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    uint16_t DNSAlert::QuestionType(uint16_t questionType)
    {
      std::get<2>(_data) = questionType;
      return std::get<2>(_data);
    }

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    string DNSAlert::DisplayString() const
    {
      static const map<uint16_t,string>  qtypes = {
        { Dns::MessageQuestion::k_typeA,     "A"     },
        { Dns::MessageQuestion::k_typeNS,    "NS"    },
        { Dns::MessageQuestion::k_typeCNAME, "CNAME" },
        { Dns::MessageQuestion::k_typeSOA,   "SOA"   },
        { Dns::MessageQuestion::k_typePTR,   "PTR"   },
        { Dns::MessageQuestion::k_typeMX,    "MX"    },
        { Dns::MessageQuestion::k_typeAAAA,  "AAAA"  },
        { Dns::MessageQuestion::k_typeLOC,   "LOC"   }
      };

#if 0
      string  rc = Utils::GetHostName(Server().Raw());
      if (rc.empty()) {
        rc = (string)Server();
      }
#else
      string  rc = (string)Server();
#endif
      rc += ' ';
      rc += Question() + '(';
      auto  qtiter = qtypes.find(QuestionType());
      if (qtiter != qtypes.end()) {
        rc += qtiter->second;
      }
      else {
        rc += "???";
      }
      rc += ") DNS";
      return rc;
    }

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    nlohmann::json DNSAlert::ToJson() const
    {
      nlohmann::json  rc;
      rc["server"] = (string)Server();
      rc["question"] = Question();
      rc["qtype"] = QuestionType();
      return rc;
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    bool DNSAlert::FromJson(const nlohmann::json & j)
    {
      bool  rc = false;
      if (j.is_object()) {
        auto  server = j.find("server");
        if ((server != j.end()) && server->is_string()) {
          auto  question = j.find("question");
          if ((question != j.end()) && question->is_string()) {
            auto  qtype = j.find("qtype");
            if ((qtype != j.end()) && qtype->is_number()) {
              Server(server->get<string>());
              Question(question->get<string>());
              QuestionType(qtype->get<uint16_t>());
              rc = true;
            }
          }
        }
      }
      return rc;
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    istream & DNSAlert::Read(istream & is)
    {
      return Dwm::StreamIO::Read(is, _data);
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    ssize_t DNSAlert::Read(int fd)
    {
      return Dwm::DescriptorIO::Read(fd, _data);
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    size_t DNSAlert::Read(FILE * f)
    {
      return Dwm::FileIO::Read(f, _data);
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    ostream & DNSAlert::Write(ostream & os) const
    {
      return Dwm::StreamIO::Write(os, _data);
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    ssize_t DNSAlert::Write(int fd) const
    {
      return Dwm::DescriptorIO::Write(fd, _data);
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    size_t DNSAlert::Write(FILE *f) const
    {
      return Dwm::FileIO::Write(f, _data);
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    uint64_t DNSAlert::StreamedLength() const
    {
      return Dwm::IOUtils::StreamedLength(_data);
    }
    
  }  // namespace Mcrover

}  // namespace Dwm
