//===========================================================================
// @(#) $DwmPath: dwm/mcplex/mcrover/tags/mcrover-0.1.7/classes/src/DwmMcroverDiskAlert.cc 11886 $
// @(#) $Id: DwmMcroverDiskAlert.cc 11886 2021-04-07 05:16:39Z dwm $
//===========================================================================
//  Copyright (c) Daniel W. McRobb 2020
//  All rights reserved.
//
//  Redistribution and use in source and binary forms, with or without
//  modification, are permitted provided that the following conditions
//  are met:
//
//  1. Redistributions of source code must retain the above copyright
//     notice, this list of conditions and the following disclaimer.
//  2. Redistributions in binary form must reproduce the above copyright
//     notice, this list of conditions and the following disclaimer in the
//     documentation and/or other materials provided with the distribution.
//  3. The names of the authors and copyright holders may not be used to
//     endorse or promote products derived from this software without
//     specific prior written permission.
//
//  IN NO EVENT SHALL DANIEL W. MCROBB BE LIABLE TO ANY PARTY FOR
//  DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES,
//  INCLUDING LOST PROFITS, ARISING OUT OF THE USE OF THIS SOFTWARE,
//  EVEN IF DANIEL W. MCROBB HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH
//  DAMAGE.
//
//  THE SOFTWARE PROVIDED HEREIN IS ON AN "AS IS" BASIS, AND
//  DANIEL W. MCROBB HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT,
//  UPDATES, ENHANCEMENTS, OR MODIFICATIONS. DANIEL W. MCROBB MAKES NO
//  REPRESENTATIONS AND EXTENDS NO WARRANTIES OF ANY KIND, EITHER
//  IMPLIED OR EXPRESS, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
//  WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE,
//  OR THAT THE USE OF THIS SOFTWARE WILL NOT INFRINGE ANY PATENT,
//  TRADEMARK OR OTHER RIGHTS.
//===========================================================================

//---------------------------------------------------------------------------
//!  \file DwmMcroverDiskAlert.cc
//!  \author Daniel W. McRobb
//!  \brief Dwm::Mcrover::DiskAlert class implementation
//---------------------------------------------------------------------------

#include "DwmDescriptorIO.hh"
#include "DwmFileIO.hh"
#include "DwmIOUtils.hh"
#include "DwmStreamIO.hh"
#include "DwmIpv4Address.hh"
#include "DwmSvnTag.hh"
#include "DwmMcroverDiskAlert.hh"
#include "DwmMcroverUtils.hh"

static const Dwm::SvnTag svntag("@(#) $DwmPath: dwm/mcplex/mcrover/tags/mcrover-0.1.7/classes/src/DwmMcroverDiskAlert.cc 11886 $");

namespace Dwm {

  namespace Mcrover {

    using namespace std;
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    DiskAlert::DiskAlert()
        : _data()
    {
      _data.first = Ipv4Address(INADDR_NONE);
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    DiskAlert::DiskAlert(const Ipv4Address & localAddr,
                         const pair<string,string> & disk)
    {
      _data.first = localAddr;
      _data.second = disk;
    }

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    string DiskAlert::DisplayString() const
    {
      string  rc = (string)(_data.first) + ':';
      rc += _data.second.first + ':';
      rc += _data.second.second;
      rc += " DISK";
      return rc;
    }

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    nlohmann::json DiskAlert::ToJson() const
    {
      nlohmann::json  j;
      j["local"]  = (string)_data.first;
      j["device"] = _data.second.first;
      j["name"]   = _data.second.second;
      return j;
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    bool DiskAlert::FromJson(const nlohmann::json & j)
    {
      Clear();
      bool  rc = false;
      if (j.is_object()) {
        auto  local = j.find("local");
        if ((local != j.end()) && local->is_string()) {
          _data.first = Ipv4Address(local->get<string>());
          auto  device = j.find("device");
          if ((device != j.end()) && device->is_string()) {
            _data.second.first = device->get<string>();
            auto  name = j.find("name");
            if ((name != j.end()) && name->is_string()) {
              _data.second.second = name->get<string>();
              rc = true;
            }
          }
        }
      }
      return rc;
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    istream & DiskAlert::Read(istream & is)
    {
      Clear();
      return StreamIO::Read(is, _data);
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    ssize_t DiskAlert::Read(int fd)
    {
      Clear();
      return DescriptorIO::Read(fd, _data);
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    size_t DiskAlert::Read(FILE * f)
    {
      Clear();
      return FileIO::Read(f, _data);
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    ostream & DiskAlert::Write(ostream & os) const
    {
      return StreamIO::Write(os, _data);
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    ssize_t DiskAlert::Write(int fd) const
    {
      return DescriptorIO::Write(fd, _data);
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    size_t DiskAlert::Write(FILE *f) const
    {
      return FileIO::Write(f, _data);
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    uint64_t DiskAlert::StreamedLength() const
    {
      return IOUtils::StreamedLength(_data);
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    void DiskAlert::Clear()
    {
      _data.first = INADDR_NONE;
      _data.second.first.clear();
      _data.second.second.clear();
    }
    
    
  }  // namespace Mcrover

}  // namespace Dwm
