%{
  //===========================================================================
  // @(#) $DwmPath$
  //===========================================================================
  //  Copyright (c) Daniel W. McRobb 2023
  //  All rights reserved.
  //
  //  Redistribution and use in source and binary forms, with or without
  //  modification, are permitted provided that the following conditions
  //  are met:
  //
  //  1. Redistributions of source code must retain the above copyright
  //     notice, this list of conditions and the following disclaimer.
  //  2. Redistributions in binary form must reproduce the above copyright
  //     notice, this list of conditions and the following disclaimer in the
  //     documentation and/or other materials provided with the distribution.
  //  3. The names of the authors and copyright holders may not be used to
  //     endorse or promote products derived from this software without
  //     specific prior written permission.
  //
  //  IN NO EVENT SHALL DANIEL W. MCROBB BE LIABLE TO ANY PARTY FOR
  //  DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES,
  //  INCLUDING LOST PROFITS, ARISING OUT OF THE USE OF THIS SOFTWARE,
  //  EVEN IF DANIEL W. MCROBB HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH
  //  DAMAGE.
  //
  //  THE SOFTWARE PROVIDED HEREIN IS ON AN "AS IS" BASIS, AND
  //  DANIEL W. MCROBB HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT,
  //  UPDATES, ENHANCEMENTS, OR MODIFICATIONS. DANIEL W. MCROBB MAKES NO
  //  REPRESENTATIONS AND EXTENDS NO WARRANTIES OF ANY KIND, EITHER
  //  IMPLIED OR EXPRESS, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
  //  WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE,
  //  OR THAT THE USE OF THIS SOFTWARE WILL NOT INFRINGE ANY PATENT,
  //  TRADEMARK OR OTHER RIGHTS.
  //===========================================================================
  
  //---------------------------------------------------------------------------
  //!  \file DwmMcroverDumpDates.lex
  //!  \author Daniel W. McRobb
  //!  \brief NOT YET DOCUMENTED
  //---------------------------------------------------------------------------

  extern "C" {
    #include <stdio.h>
    #include <stdlib.h>
    #include <string.h>
    #include <fstab.h>
#ifdef __linux__
    #include <mntent.h>
#endif
  }
  
  #include <iomanip>
  #include <iostream>
  #include <string>
  #include <iostream>

  #include "DwmMcroverDumpDates.hh"

  #define DEVICE  300
  #define LEVEL   301

  using namespace std;

  static string rcsid("@(#) $Name$ $Id$");
%}

%option prefix="mcroverdumpdates"
%option noyywrap

m_dayOfWeek  Sun|Mon|Tue|Wed|Thu|Fri|Sat
m_month      Jan|Feb|Mar|Apr|May|Jun|Jul|Aug|Sep|Oct|Nov|Dec

%x x_device
%x x_level
%x x_dayOfWeek
%x x_month
%x x_dayOfMonth
%x x_hour
%x x_minute
%x x_second
%x x_year
%x x_maybeTZ

%%

<INITIAL>^\/[^ \t]+         { BEGIN(x_level); return(x_device); }
<INITIAL>[ \t\n]+
<x_level>[0-9]+             { BEGIN(x_dayOfWeek); return(x_level); } 
<x_level>.
<x_level>\n	                { BEGIN(INITIAL); }
<x_dayOfWeek>{m_dayOfWeek}  { BEGIN(x_month); return(x_dayOfWeek); }
<x_dayOfWeek>.
<x_dayOfWeek>\n	            { BEGIN(INITIAL); }
<x_month>{m_month}          { BEGIN(x_dayOfMonth); return(x_month); }
<x_month>.
<x_month>\n                 { BEGIN(INITIAL); }
<x_dayOfMonth>[0-9]+        { BEGIN(x_hour); return(x_dayOfMonth); }
<x_dayOfMonth>.
<x_dayOfMonth>\n            { BEGIN(INITIAL); }
<x_hour>[0-9]+              { return(x_hour); }
<x_hour>\:                  { BEGIN(x_minute); }
<x_hour>.
<x_hour>\n                  { BEGIN(INITIAL); }
<x_minute>[0-9]+            { return(x_minute); }
<x_minute>\:                { BEGIN(x_second); }
<x_minute>.
<x_minute>\n                { BEGIN(INITIAL); }
<x_second>[0-9]+            { BEGIN(x_year); return(x_second); } 
<x_second>.
<x_second>\n                { BEGIN(INITIAL); }
<x_year>[0-9]+              { BEGIN(x_maybeTZ); return(x_year); }
<x_year>.
<x_year>\n                  { BEGIN(INITIAL); }
<x_maybeTZ>.*
<x_maybeTZ>\n               { BEGIN(INITIAL); }

%%

namespace Dwm {

  namespace Mcrover {

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    DumpDates::DumpDates(const string & optFileName)
        : _data()
    {
      string  fileName(optFileName);
      if (fileName.empty()) {
#ifdef __linux__
        fileName = "/var/lib/dumpdates";
#else
        fileName = "/etc/dumpdates";
#endif
      }
      
      mcroverdumpdatesin = fopen(fileName.c_str(), "r");
      if (mcroverdumpdatesin) {
        int        lexrc;
        string     dev;
        int        level;
        struct tm  tms;
        memset(&tms,0,sizeof(tms));
          
        while ((lexrc = mcroverdumpdateslex())) {
          switch (lexrc) {
            case x_device:
              dev = yytext;
              break;

            case x_level:
              level = atoi(yytext);
              break;

            case x_dayOfWeek:
              break;

            case x_month:
              if (string(yytext) == "Jan")
                tms.tm_mon = 0;
              else if (string(yytext) == "Feb")
                tms.tm_mon = 1;
              else if (string(yytext) == "Mar")
                tms.tm_mon = 2;
              else if (string(yytext) == "Apr")
                tms.tm_mon = 3;
              else if (string(yytext) == "May")
                tms.tm_mon = 4;
              else if (string(yytext) == "Jun")
                tms.tm_mon = 5;
              else if (string(yytext) == "Jul")
                tms.tm_mon = 6;
              else if (string(yytext) == "Aug")
                tms.tm_mon = 7;
              else if (string(yytext) == "Sep")
                tms.tm_mon = 8;
              else if (string(yytext) == "Oct")
                tms.tm_mon = 9;
              else if (string(yytext) == "Nov")
                tms.tm_mon = 10;
              else if (string(yytext) == "Dec")
                tms.tm_mon = 11;
              break;
              
            case x_dayOfMonth:
              tms.tm_mday = atoi(yytext);
              break;
              
            case x_hour:
              tms.tm_hour = atoi(yytext);
              break;
              
            case x_minute:
              tms.tm_min = atoi(yytext);
              break;
              
            case x_second:
              tms.tm_sec = atoi(yytext);
              break;
              
            case x_year:
              tms.tm_year = atoi(yytext) - 1900;
              tms.tm_isdst = -1;
              (_data[dev])[level] = mktime(&tms);
              memset(&tms,0,sizeof(tms));
              break;
              
            default:
              break;
          }
        }
        fclose(mcroverdumpdatesin);
      }
    }

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    ostream & operator << (ostream & os, const DumpDates & dd)
    {
      if (os) {
        const char *days[7] = {
          "Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"
        };
        const char *months[12] = {
          "Jan", "Feb", "Mar", "Apr", "May", "Jun", 
          "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"
        };

        map<string,map<int,time_t> >::const_iterator  dIter;
        for (dIter = dd._data.begin(); dIter != dd._data.end(); ++dIter) {
          map<int,time_t>::const_iterator  lIter;
          for (lIter = dIter->second.begin(); 
               lIter != dIter->second.end(); ++lIter) {
            os << dIter->first.c_str() << "\t" << lIter->first << " ";
            struct tm  *tmp = localtime(&(lIter->second));
            os << days[tmp->tm_wday] << " " << months[tmp->tm_mon] << " "
               << tmp->tm_mday << " "
               << setfill('0') 
               << setw(2) << tmp->tm_hour << ":" 
               << setw(2) << tmp->tm_min << ":"
               << setw(2) << tmp->tm_sec << " " 
               << tmp->tm_year + 1900
               << setfill(' ')
               << endl;
          }
        }
        
      }
      return(os);
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    time_t DumpDates::LastDumpAtLevel(const string & fs, int level) const
    {
      time_t  rc = 0;
      map<string,map<int,time_t> >::const_iterator  fsIter = _data.find(fs);
      if (fsIter == _data.end()) {
#ifdef __linux__
        FILE *mtab = setmntent("/etc/mtab","r");
        struct mntent  *mntEntry;
        while ((mntEntry = getmntent(mtab))) {
          if (fs == mntEntry->mnt_dir) {
            fsIter = _data.find(mntEntry->mnt_fsname);
            break;
          }
        }
        endmntent(mtab);
#else
        setfsent();
        struct fstab  *fsp;
        while ((fsp = getfsent())) {
          if (fs == fsp->fs_file) {
            fsIter = _data.find(fsp->fs_spec);
            break;
          }
        }
        endfsent();
#endif
      }
      
      if (fsIter != _data.end()) {
        map<int,time_t>::const_iterator  dIter = fsIter->second.find(level);
        if (dIter != fsIter->second.end()) {
          rc = dIter->second;
        }
      }
      return(rc);
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    pair<int,time_t> DumpDates::LastDump(const string & fs) const
    {
      pair<int,time_t>  rc(0,0);
      map<string,map<int,time_t> >::const_iterator  fsIter = _data.find(fs);
      if (fsIter == _data.end()) {
        setfsent();
        struct fstab  *fsp;
        while ((fsp = getfsent())) {
          if (fs == fsp->fs_file) {
            fsIter = _data.find(fsp->fs_spec);
            break;
          }
        }
        endfsent();
      }
      
      if (fsIter != _data.end()) {
        map<int,time_t>::const_iterator  dIter;
        for (dIter = fsIter->second.begin(); 
             dIter != fsIter->second.end(); ++dIter) {
          if (dIter->second > rc.second) {
            rc.first = dIter->first;
            rc.second = dIter->second;
          }
        }
      }
      return(rc);
    }

  }  // namespace Mcrover

}  // namespace Dwm
