//===========================================================================
// @(#) $DwmPath: dwm/mcplex/mcrover/tags/mcrover-0.1.7/classes/src/DwmMcroverGuestAlert.cc 11886 $
// @(#) $Id: DwmMcroverGuestAlert.cc 11886 2021-04-07 05:16:39Z dwm $
//===========================================================================
//  Copyright (c) Daniel W. McRobb 2020
//  All rights reserved.
//
//  Redistribution and use in source and binary forms, with or without
//  modification, are permitted provided that the following conditions
//  are met:
//
//  1. Redistributions of source code must retain the above copyright
//     notice, this list of conditions and the following disclaimer.
//  2. Redistributions in binary form must reproduce the above copyright
//     notice, this list of conditions and the following disclaimer in the
//     documentation and/or other materials provided with the distribution.
//  3. The names of the authors and copyright holders may not be used to
//     endorse or promote products derived from this software without
//     specific prior written permission.
//
//  IN NO EVENT SHALL DANIEL W. MCROBB BE LIABLE TO ANY PARTY FOR
//  DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES,
//  INCLUDING LOST PROFITS, ARISING OUT OF THE USE OF THIS SOFTWARE,
//  EVEN IF DANIEL W. MCROBB HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH
//  DAMAGE.
//
//  THE SOFTWARE PROVIDED HEREIN IS ON AN "AS IS" BASIS, AND
//  DANIEL W. MCROBB HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT,
//  UPDATES, ENHANCEMENTS, OR MODIFICATIONS. DANIEL W. MCROBB MAKES NO
//  REPRESENTATIONS AND EXTENDS NO WARRANTIES OF ANY KIND, EITHER
//  IMPLIED OR EXPRESS, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
//  WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE,
//  OR THAT THE USE OF THIS SOFTWARE WILL NOT INFRINGE ANY PATENT,
//  TRADEMARK OR OTHER RIGHTS.
//===========================================================================

//---------------------------------------------------------------------------
//!  \file DwmMcroverGuestAlert.cc
//!  \author Daniel W. McRobb
//!  \brief Dwm::Mcrover::GuestAlert class implementation
//---------------------------------------------------------------------------

#include "DwmIpv4Address.hh"
#include "DwmDescriptorIO.hh"
#include "DwmFileIO.hh"
#include "DwmIOUtils.hh"
#include "DwmStreamIO.hh"
#include "DwmSvnTag.hh"
#include "DwmMcroverGuestAlert.hh"
#include "DwmMcroverUtils.hh"

static const Dwm::SvnTag svntag("@(#) $DwmPath: dwm/mcplex/mcrover/tags/mcrover-0.1.7/classes/src/DwmMcroverGuestAlert.cc 11886 $");

namespace Dwm {

  namespace Mcrover {

    using namespace std;
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    GuestAlert::GuestAlert()
        : _localAndGuest(MacAddress(), INADDR_NONE)
    {
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    GuestAlert::GuestAlert(const MacAddress & guestMac,
                           const Ipv4Address & guestIp)
        : _localAndGuest(guestMac, guestIp)
    {}
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    string GuestAlert::DisplayString() const
    {
      return ((string)_localAndGuest.first + ","
              + (string)_localAndGuest.second + " GUEST");
    }

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    nlohmann::json GuestAlert::ToJson() const
    {
      nlohmann::json  j;
      j["mac"] = (string)_localAndGuest.first;
      j["ip"] = (string)_localAndGuest.second;
      return j;
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    bool GuestAlert::FromJson(const nlohmann::json & j)
    {
      bool  rc = false;
      _localAndGuest.first = MacAddress("00:00:00:00:00:00");
      _localAndGuest.second = INADDR_NONE;
      if (j.is_object()) {
        auto  mac = j.find("mac");
        if ((mac != j.end()) && mac->is_string()) {
          _localAndGuest.first = MacAddress(mac->get<string>());
          auto  ip = j.find("ip");
          if ((ip != j.end()) && ip->is_string()) {
            _localAndGuest.second = Ipv4Address(ip->get<string>());
            rc = true;
          }
        }
      }
      return rc;
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    istream & GuestAlert::Read(istream & is)
    {
      _localAndGuest.first = MacAddress();
      _localAndGuest.second = INADDR_NONE;
      return StreamIO::Read(is, _localAndGuest);
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    ssize_t GuestAlert::Read(int fd)
    {
      _localAndGuest.first = MacAddress();
      _localAndGuest.second = INADDR_NONE;
      return DescriptorIO::Read(fd, _localAndGuest);
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    size_t GuestAlert::Read(FILE * f)
    {
      _localAndGuest.first = MacAddress();
      _localAndGuest.second = INADDR_NONE;
      return FileIO::Read(f, _localAndGuest);
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    ostream & GuestAlert::Write(ostream & os) const
    {
      return StreamIO::Write(os, _localAndGuest);
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    ssize_t GuestAlert::Write(int fd) const
    {
      return DescriptorIO::Write(fd, _localAndGuest);
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    size_t GuestAlert::Write(FILE *f) const
    {
      return FileIO::Write(f, _localAndGuest);
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    uint64_t GuestAlert::StreamedLength() const
    {
      return (IOUtils::StreamedLength(_localAndGuest));
    }
    
  }  // namespace Mcrover

}  // namespace Dwm
