//===========================================================================
// @(#) $DwmPath: dwm/mcplex/mcrover/tags/mcrover-0.1.7/classes/src/DwmMcroverHTTPAddr.cc 11049 $
// @(#) $Id: DwmMcroverHTTPAddr.cc 11049 2020-08-31 03:40:46Z dwm $
//===========================================================================
//  Copyright (c) Daniel W. McRobb 2020
//  All rights reserved.
//
//  Redistribution and use in source and binary forms, with or without
//  modification, are permitted provided that the following conditions
//  are met:
//
//  1. Redistributions of source code must retain the above copyright
//     notice, this list of conditions and the following disclaimer.
//  2. Redistributions in binary form must reproduce the above copyright
//     notice, this list of conditions and the following disclaimer in the
//     documentation and/or other materials provided with the distribution.
//  3. The names of the authors and copyright holders may not be used to
//     endorse or promote products derived from this software without
//     specific prior written permission.
//
//  IN NO EVENT SHALL DANIEL W. MCROBB BE LIABLE TO ANY PARTY FOR
//  DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES,
//  INCLUDING LOST PROFITS, ARISING OUT OF THE USE OF THIS SOFTWARE,
//  EVEN IF DANIEL W. MCROBB HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH
//  DAMAGE.
//
//  THE SOFTWARE PROVIDED HEREIN IS ON AN "AS IS" BASIS, AND
//  DANIEL W. MCROBB HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT,
//  UPDATES, ENHANCEMENTS, OR MODIFICATIONS. DANIEL W. MCROBB MAKES NO
//  REPRESENTATIONS AND EXTENDS NO WARRANTIES OF ANY KIND, EITHER
//  IMPLIED OR EXPRESS, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
//  WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE,
//  OR THAT THE USE OF THIS SOFTWARE WILL NOT INFRINGE ANY PATENT,
//  TRADEMARK OR OTHER RIGHTS.
//===========================================================================

//---------------------------------------------------------------------------
//!  \file DwmMcroverHTTPAddr.cc
//!  \author Daniel W. McRobb
//!  \brief Dwm::Mcrover::HTTPAddr class implementation
//---------------------------------------------------------------------------

#include "DwmMcroverHTTPAddr.hh"

namespace Dwm {

  namespace Mcrover {

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    HTTPAddr::HTTPAddr()
        : _addr("", INADDR_NONE, 0), _vhost(), _page()
    {}
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    HTTPAddr::HTTPAddr(const std::string & name, const Ipv4Address & addr,
                       uint16_t port, const std::string & vhost,
                       const std::string & page)
        : _addr(name, addr.Raw(), port), _vhost(vhost), _page(page)
    {}

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    const std::string	& HTTPAddr::Name() const
    {
      return _addr.Name();
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    const std::string & HTTPAddr::Name(const std::string & name)
    {
      _addr.Name(name);
      return _addr.Name();
    }

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    const Tcp4DstAddr & HTTPAddr::Address() const
    {
      return _addr;
    }

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    in_addr_t HTTPAddr::Address(in_addr_t addr)
    {
      return _addr.Address(addr);
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    uint16_t HTTPAddr::Port(uint16_t port)
    {
      return _addr.Port(port);
    }

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    const std::string & HTTPAddr::VHost() const
    {
      return _vhost;
    }

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    const std::string & HTTPAddr::VHost(const std::string & vhost)
    {
      _vhost = vhost;
      return _vhost;
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    const std::string & HTTPAddr::Page() const
    {
      return _page;
    }

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    const std::string & HTTPAddr::Page(const std::string & page)
    {
      _page = page;
      return _page;
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    bool HTTPAddr::operator < (const HTTPAddr & addr) const
    {
      bool  rc = false;
      if (_addr < addr._addr) {
        rc = true;
      }
      else if (_addr == addr._addr) {
        if (_vhost < addr._vhost) {
          rc = true;
        }
        else if (_vhost == addr._vhost) {
          if (_page < addr._page) {
            rc = true;
          }
        }
      }
      return rc;
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    bool HTTPAddr::operator == (const HTTPAddr & addr) const
    {
      return ((_addr == addr._addr)
              && (_vhost == addr._vhost)
              && (_page == addr._page));
    }


  }  // namespace Mcrover

}  // namespace Dwm
