//===========================================================================
// @(#) $DwmPath: dwm/mcplex/mcrover/tags/mcrover-0.1.7/classes/src/DwmMcroverHttpStatusHandler.cc 10997 $
// @(#) $Id: DwmMcroverHttpStatusHandler.cc 10997 2020-08-27 05:34:16Z dwm $
//===========================================================================
//  Copyright (c) Daniel W. McRobb 2020
//  All rights reserved.
//
//  Redistribution and use in source and binary forms, with or without
//  modification, are permitted provided that the following conditions
//  are met:
//
//  1. Redistributions of source code must retain the above copyright
//     notice, this list of conditions and the following disclaimer.
//  2. Redistributions in binary form must reproduce the above copyright
//     notice, this list of conditions and the following disclaimer in the
//     documentation and/or other materials provided with the distribution.
//  3. The names of the authors and copyright holders may not be used to
//     endorse or promote products derived from this software without
//     specific prior written permission.
//
//  IN NO EVENT SHALL DANIEL W. MCROBB BE LIABLE TO ANY PARTY FOR
//  DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES,
//  INCLUDING LOST PROFITS, ARISING OUT OF THE USE OF THIS SOFTWARE,
//  EVEN IF DANIEL W. MCROBB HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH
//  DAMAGE.
//
//  THE SOFTWARE PROVIDED HEREIN IS ON AN "AS IS" BASIS, AND
//  DANIEL W. MCROBB HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT,
//  UPDATES, ENHANCEMENTS, OR MODIFICATIONS. DANIEL W. MCROBB MAKES NO
//  REPRESENTATIONS AND EXTENDS NO WARRANTIES OF ANY KIND, EITHER
//  IMPLIED OR EXPRESS, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
//  WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE,
//  OR THAT THE USE OF THIS SOFTWARE WILL NOT INFRINGE ANY PATENT,
//  TRADEMARK OR OTHER RIGHTS.
//===========================================================================

//---------------------------------------------------------------------------
//!  \file DwmMcroverHttpStatusHandler.cc
//!  \author Daniel W. McRobb
//!  \brief Dwm::Mcrover::HttpStatusHandler class implementation
//---------------------------------------------------------------------------

#include "DwmSvnTag.hh"
#include "DwmSysLogger.hh"
#include "DwmMcroverHttpStatusHandler.hh"

static const Dwm::SvnTag svntag("@(#) $DwmPath: dwm/mcplex/mcrover/tags/mcrover-0.1.7/classes/src/DwmMcroverHttpStatusHandler.cc 10997 $");

namespace Dwm {

  namespace Mcrover {

    using namespace std;

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    HttpStatusHandler::HttpStatusHandler(const AlertOrigin & origin,
                                         AlertBowl & alerts)
        : _origin(origin), _alerts(alerts), _mtx()
    {}

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    void HttpStatusHandler::HandleStatus(const HttpStatusJob & job)
    {
      Syslog(LOG_INFO, "Response for %s: %d", job.webTarget.URI().c_str(),
             job.status);
      if (! job.webTarget.GoodResponses().InRange(job.status)) {
        lock_guard<mutex>  lck(_mtx);
        _alerts.Add(_origin, WebAlert(job.webTarget.URI(), job.status),
                    time((time_t *)0));
      }
      return;
    }
    
  }  // namespace Mcrover

}  // namespace Dwm
