//===========================================================================
// @(#) $DwmPath: dwm/mcplex/mcrover/tags/mcrover-0.1.7/classes/src/DwmMcroverMessageHeader.cc 11886 $
// @(#) $Id: DwmMcroverMessageHeader.cc 11886 2021-04-07 05:16:39Z dwm $
//===========================================================================
//  Copyright (c) Daniel W. McRobb 2020
//  All rights reserved.
//
//  Redistribution and use in source and binary forms, with or without
//  modification, are permitted provided that the following conditions
//  are met:
//
//  1. Redistributions of source code must retain the above copyright
//     notice, this list of conditions and the following disclaimer.
//  2. Redistributions in binary form must reproduce the above copyright
//     notice, this list of conditions and the following disclaimer in the
//     documentation and/or other materials provided with the distribution.
//  3. The names of the authors and copyright holders may not be used to
//     endorse or promote products derived from this software without
//     specific prior written permission.
//
//  IN NO EVENT SHALL DANIEL W. MCROBB BE LIABLE TO ANY PARTY FOR
//  DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES,
//  INCLUDING LOST PROFITS, ARISING OUT OF THE USE OF THIS SOFTWARE,
//  EVEN IF DANIEL W. MCROBB HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH
//  DAMAGE.
//
//  THE SOFTWARE PROVIDED HEREIN IS ON AN "AS IS" BASIS, AND
//  DANIEL W. MCROBB HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT,
//  UPDATES, ENHANCEMENTS, OR MODIFICATIONS. DANIEL W. MCROBB MAKES NO
//  REPRESENTATIONS AND EXTENDS NO WARRANTIES OF ANY KIND, EITHER
//  IMPLIED OR EXPRESS, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
//  WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE,
//  OR THAT THE USE OF THIS SOFTWARE WILL NOT INFRINGE ANY PATENT,
//  TRADEMARK OR OTHER RIGHTS.
//===========================================================================

//---------------------------------------------------------------------------
//!  \file DwmMcroverMessageHeader.cc
//!  \author Daniel W. McRobb
//!  \brief Dwm::Mcrover::MessageHeader class implementation
//---------------------------------------------------------------------------

#include "DwmDescriptorIO.hh"
#include "DwmFileIO.hh"
#include "DwmIOUtils.hh"
#include "DwmStreamIO.hh"
#include "DwmSvnTag.hh"
#include "DwmMcroverMessageHeader.hh"

static const Dwm::SvnTag svntag("@(#) $DwmPath: dwm/mcplex/mcrover/tags/mcrover-0.1.7/classes/src/DwmMcroverMessageHeader.cc 11886 $");

namespace Dwm {

  namespace Mcrover {

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    static const std::unordered_map<uint32_t,std::string>
    g_msgTypeToName = {
      { MessageHeader::e_typeNone,         "None"         },
      { MessageHeader::e_typeUpdateAlert,  "UpdateAlert"  },
      { MessageHeader::e_typeDeleteAlert,  "DeleteAlert"  }
    };

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    MessageHeader::MessageHeader()
        : _data({ "", INADDR_NONE, e_typeNone, 0 })
    {}
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    MessageHeader::MessageHeader(const std::string & pack,
                                 const Ipv4Address & member,
                                 MsgTypeEnum msgType,
                                 uint32_t payloadLength)
        : _data({ pack, member, msgType, payloadLength })
    {}
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    const std::string & MessageHeader::Pack() const
    { return std::get<0>(_data); }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    const std::string & MessageHeader::Pack(const std::string & pack)
    { std::get<0>(_data) = pack;  return std::get<0>(_data); }

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    const Ipv4Address & MessageHeader::Member() const
    { return std::get<1>(_data); }

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    const Ipv4Address & MessageHeader::Member(const Ipv4Address & member)
    { std::get<1>(_data) = member;  return std::get<1>(_data); }

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    MessageHeader::MsgTypeEnum MessageHeader::Type() const
    { return static_cast<MsgTypeEnum>(std::get<2>(_data)); }

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    std::string MessageHeader::TypeName() const
    {
      return TypeName(static_cast<MsgTypeEnum>(std::get<2>(_data)));
    }

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    std::string MessageHeader::TypeName(MessageHeader::MsgTypeEnum msgType)
    {
      std::string  rc;
      auto  it = g_msgTypeToName.find(msgType);
      if (it != g_msgTypeToName.end()) {
        rc = it->second;
      }
      else {
        rc = "Unknown (" + std::to_string((uint32_t)msgType) + ')';
      }
      return rc;
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    MessageHeader::MsgTypeEnum
    MessageHeader::Type(MessageHeader::MsgTypeEnum msgType)
    {
      std::get<2>(_data) = msgType;
      return static_cast<MsgTypeEnum>(std::get<2>(_data));
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    uint32_t MessageHeader::PayloadLength() const
    { return std::get<3>(_data); }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    uint32_t MessageHeader::PayloadLength(uint32_t payloadLength)
    { std::get<3>(_data) = payloadLength;  return std::get<3>(_data); }
        
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    std::istream & MessageHeader::Read(std::istream & is)
    { return StreamIO::Read(is, _data); }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    ssize_t MessageHeader::Read(int fd)
    { return DescriptorIO::Read(fd, _data); }

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    size_t MessageHeader::Read(FILE *f)
    { return FileIO::Read(f, _data); }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    std::ostream & MessageHeader::Write(std::ostream & os) const
    { return StreamIO::Write(os, _data); }

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    ssize_t MessageHeader::Write(int fd) const
    { return DescriptorIO::Write(fd, _data); }

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    size_t MessageHeader::Write(FILE *f) const
    { return FileIO::Write(f, _data); }

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    uint64_t MessageHeader::StreamedLength() const
    { return IOUtils::StreamedLength(_data); }
    
    
  }  // namespace Mcrover
  
}  // namespace Dwm
