//===========================================================================
// @(#) $DwmPath: dwm/mcplex/mcrover/tags/mcrover-0.1.7/classes/src/DwmMcroverRouteAlert.cc 11886 $
// @(#) $Id: DwmMcroverRouteAlert.cc 11886 2021-04-07 05:16:39Z dwm $
//===========================================================================
//  Copyright (c) Daniel W. McRobb 2020
//  All rights reserved.
//
//  Redistribution and use in source and binary forms, with or without
//  modification, are permitted provided that the following conditions
//  are met:
//
//  1. Redistributions of source code must retain the above copyright
//     notice, this list of conditions and the following disclaimer.
//  2. Redistributions in binary form must reproduce the above copyright
//     notice, this list of conditions and the following disclaimer in the
//     documentation and/or other materials provided with the distribution.
//  3. The names of the authors and copyright holders may not be used to
//     endorse or promote products derived from this software without
//     specific prior written permission.
//
//  IN NO EVENT SHALL DANIEL W. MCROBB BE LIABLE TO ANY PARTY FOR
//  DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES,
//  INCLUDING LOST PROFITS, ARISING OUT OF THE USE OF THIS SOFTWARE,
//  EVEN IF DANIEL W. MCROBB HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH
//  DAMAGE.
//
//  THE SOFTWARE PROVIDED HEREIN IS ON AN "AS IS" BASIS, AND
//  DANIEL W. MCROBB HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT,
//  UPDATES, ENHANCEMENTS, OR MODIFICATIONS. DANIEL W. MCROBB MAKES NO
//  REPRESENTATIONS AND EXTENDS NO WARRANTIES OF ANY KIND, EITHER
//  IMPLIED OR EXPRESS, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
//  WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE,
//  OR THAT THE USE OF THIS SOFTWARE WILL NOT INFRINGE ANY PATENT,
//  TRADEMARK OR OTHER RIGHTS.
//===========================================================================

//---------------------------------------------------------------------------
//!  \file DwmMcroverRouteAlert.cc
//!  \author Daniel W. McRobb
//!  \brief Dwm::Mcrover::RouteAlert class implementation
//---------------------------------------------------------------------------

#include "DwmDescriptorIO.hh"
#include "DwmFileIO.hh"
#include "DwmIOUtils.hh"
#include "DwmStreamIO.hh"
#include "DwmIpv4Address.hh"
#include "DwmSvnTag.hh"
#include "DwmMcroverRouteAlert.hh"
#include "DwmMcroverUtils.hh"

static const Dwm::SvnTag svntag("@(#) $DwmPath: dwm/mcplex/mcrover/tags/mcrover-0.1.7/classes/src/DwmMcroverRouteAlert.cc 11886 $");

namespace Dwm {

  namespace Mcrover {

    using namespace std;
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    RouteAlert::RouteAlert()
    {
      get<0>(_data) = INADDR_NONE;
      get<1>(_data) = Ipv4Prefix(Ipv4Address(INADDR_NONE), 32);
      get<2>(_data) = INADDR_NONE;
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    RouteAlert::RouteAlert(const Ipv4Address & localAddr,
                           const Ipv4Prefix & destination,
                           const Ipv4Address & gateway)
    {
      get<0>(_data) = localAddr;
      get<1>(_data) = destination;
      get<2>(_data) = gateway;
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    string RouteAlert::DisplayString() const
    {
      string  rc;
      if (get<1>(_data) == Ipv4Prefix("0/0")) {
        rc += "default";
      }
      else {
        rc += get<1>(_data).ToString();
      }
      rc += ':';
      rc += (string)get<2>(_data) + " ROUTE";
      return rc;
    }

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    nlohmann::json RouteAlert::ToJson() const
    {
      nlohmann::json  j;
      j["local"] = (string)get<0>(_data);
      j["dst"] = get<1>(_data).ToString();
      j["gw"] = (string)get<2>(_data);
      return j;
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    bool RouteAlert::FromJson(const nlohmann::json & j)
    {
      bool  rc = false;
      get<0>(_data) = INADDR_NONE;
      get<1>(_data).Set(Ipv4Address("255.255.255.255"), 32);
      get<2>(_data) = INADDR_NONE;
      
      if (j.is_object()) {
        auto  local = j.find("local");
        if ((local != j.end()) && local->is_string()) {
          get<0>(_data) = Ipv4Address(local->get<string>());
          auto  dst = j.find("dst");
          if ((dst != j.end()) && dst->is_string()) {
            get<1>(_data) = Ipv4Prefix(dst->get<string>());
            auto  gw = j.find("gw");
            if ((gw != j.end()) && gw->is_string()) {
              get<2>(_data) = Ipv4Address(gw->get<string>());
              rc = true;
            }
          }
        }
      }
      return rc;
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    istream & RouteAlert::Read(istream & is)
    {
      Clear();
      return StreamIO::Read(is, _data);
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    ssize_t RouteAlert::Read(int fd)
    {
      Clear();
      return DescriptorIO::Read(fd, _data);
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    size_t RouteAlert::Read(FILE * f)
    {
      Clear();
      return FileIO::Read(f, _data);
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    ostream & RouteAlert::Write(ostream & os) const
    {
      return StreamIO::Write(os, _data);
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    ssize_t RouteAlert::Write(int fd) const
    {
      return DescriptorIO::Write(fd, _data);
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    size_t RouteAlert::Write(FILE *f) const
    {
      return FileIO::Write(f, _data);
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    uint64_t RouteAlert::StreamedLength() const
    {
      return IOUtils::StreamedLength(_data);
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    void RouteAlert::Clear()
    {
      get<0>(_data) = INADDR_NONE;
      get<1>(_data).Set(Ipv4Address("255.255.255.255"), 32);
      get<2>(_data) = INADDR_NONE;
      return;
    }
      
  }  // namespace Mcrover

}  // namespace Dwm
