//===========================================================================
// @(#) $DwmPath: dwm/mcplex/mcrover/trunk/classes/src/DwmMcroverSMTP6Alert.cc 11886 $
// @(#) $Id: DwmMcroverSMTP6Alert.cc 11886 2021-04-07 05:16:39Z dwm $
//===========================================================================
//  Copyright (c) Daniel W. McRobb 2020
//  All rights reserved.
//
//  Redistribution and use in source and binary forms, with or without
//  modification, are permitted provided that the following conditions
//  are met:
//
//  1. Redistributions of source code must retain the above copyright
//     notice, this list of conditions and the following disclaimer.
//  2. Redistributions in binary form must reproduce the above copyright
//     notice, this list of conditions and the following disclaimer in the
//     documentation and/or other materials provided with the distribution.
//  3. The names of the authors and copyright holders may not be used to
//     endorse or promote products derived from this software without
//     specific prior written permission.
//
//  IN NO EVENT SHALL DANIEL W. MCROBB BE LIABLE TO ANY PARTY FOR
//  DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES,
//  INCLUDING LOST PROFITS, ARISING OUT OF THE USE OF THIS SOFTWARE,
//  EVEN IF DANIEL W. MCROBB HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH
//  DAMAGE.
//
//  THE SOFTWARE PROVIDED HEREIN IS ON AN "AS IS" BASIS, AND
//  DANIEL W. MCROBB HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT,
//  UPDATES, ENHANCEMENTS, OR MODIFICATIONS. DANIEL W. MCROBB MAKES NO
//  REPRESENTATIONS AND EXTENDS NO WARRANTIES OF ANY KIND, EITHER
//  IMPLIED OR EXPRESS, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
//  WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE,
//  OR THAT THE USE OF THIS SOFTWARE WILL NOT INFRINGE ANY PATENT,
//  TRADEMARK OR OTHER RIGHTS.
//===========================================================================

//---------------------------------------------------------------------------
//!  \file DwmMcroverSMTP6Alert.cc
//!  \author Daniel W. McRobb
//!  \brief Dwm::Mcrover::SMTP6Alert class implementation
//---------------------------------------------------------------------------

#include "DwmIpv6Address.hh"
#include "DwmSvnTag.hh"
#include "DwmMcroverSMTP6Alert.hh"
#include "DwmMcroverUtils.hh"

static const Dwm::SvnTag svntag("@(#) $DwmPath: dwm/mcplex/mcrover/trunk/classes/src/DwmMcroverSMTP6Alert.cc 11886 $");

namespace Dwm {

  namespace Mcrover {

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    SMTP6Alert::SMTP6Alert()
        : _dstAddr()
    {}
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    SMTP6Alert::SMTP6Alert(const Tcp6DstAddr & dst)
        : _dstAddr(dst)
    {}
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    const Tcp6DstAddr & SMTP6Alert::Destination() const
    {
      return _dstAddr;
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    const Tcp6DstAddr & SMTP6Alert::Destination(const Tcp6DstAddr & dst)
    {
      _dstAddr = dst;
      return _dstAddr;
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    std::string SMTP6Alert::DisplayString() const
    {
      std::string  rc = Utils::GetHostName(_dstAddr.Address());
      if (rc.empty()) {
        rc = (std::string)Ipv6Address(_dstAddr.Address());
      }
      rc += ':';
      rc += std::to_string(_dstAddr.Port());
      rc += " SMTP";
      return rc;
    }

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    nlohmann::json SMTP6Alert::ToJson() const
    {
      return _dstAddr.ToJson();
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    bool SMTP6Alert::FromJson(const nlohmann::json & j)
    {
      return _dstAddr.FromJson(j);
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    std::istream & SMTP6Alert::Read(std::istream & is)
    {
      return _dstAddr.Read(is);
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    ssize_t SMTP6Alert::Read(int fd)
    {
      return _dstAddr.Read(fd);
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    size_t SMTP6Alert::Read(FILE * f)
    {
      return _dstAddr.Read(f);
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    std::ostream & SMTP6Alert::Write(std::ostream & os) const
    {
      return _dstAddr.Write(os);
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    ssize_t SMTP6Alert::Write(int fd) const
    {
      return _dstAddr.Write(fd);
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    size_t SMTP6Alert::Write(FILE *f) const
    {
      return _dstAddr.Write(f);
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    uint64_t SMTP6Alert::StreamedLength() const
    {
      return _dstAddr.StreamedLength();
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    bool SMTP6Alert::operator == (const SMTP6Alert & alert) const
    {
      return (_dstAddr == alert._dstAddr);
    }
    
  }  // namespace Mcrover

}  // namespace Dwm
