//===========================================================================
// @(#) $DwmPath: dwm/mcplex/mcrover/tags/mcrover-0.1.7/classes/src/DwmMcroverWebAlert.cc 11886 $
// @(#) $Id: DwmMcroverWebAlert.cc 11886 2021-04-07 05:16:39Z dwm $
//===========================================================================
//  Copyright (c) Daniel W. McRobb 2020
//  All rights reserved.
//
//  Redistribution and use in source and binary forms, with or without
//  modification, are permitted provided that the following conditions
//  are met:
//
//  1. Redistributions of source code must retain the above copyright
//     notice, this list of conditions and the following disclaimer.
//  2. Redistributions in binary form must reproduce the above copyright
//     notice, this list of conditions and the following disclaimer in the
//     documentation and/or other materials provided with the distribution.
//  3. The names of the authors and copyright holders may not be used to
//     endorse or promote products derived from this software without
//     specific prior written permission.
//
//  IN NO EVENT SHALL DANIEL W. MCROBB BE LIABLE TO ANY PARTY FOR
//  DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES,
//  INCLUDING LOST PROFITS, ARISING OUT OF THE USE OF THIS SOFTWARE,
//  EVEN IF DANIEL W. MCROBB HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH
//  DAMAGE.
//
//  THE SOFTWARE PROVIDED HEREIN IS ON AN "AS IS" BASIS, AND
//  DANIEL W. MCROBB HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT,
//  UPDATES, ENHANCEMENTS, OR MODIFICATIONS. DANIEL W. MCROBB MAKES NO
//  REPRESENTATIONS AND EXTENDS NO WARRANTIES OF ANY KIND, EITHER
//  IMPLIED OR EXPRESS, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
//  WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE,
//  OR THAT THE USE OF THIS SOFTWARE WILL NOT INFRINGE ANY PATENT,
//  TRADEMARK OR OTHER RIGHTS.
//===========================================================================

//---------------------------------------------------------------------------
//!  \file DwmMcroverWebAlert.cc
//!  \author Daniel W. McRobb
//!  \brief Dwm::Mcrover::WebAlert class implementation
//---------------------------------------------------------------------------

#include "DwmDescriptorIO.hh"
#include "DwmFileIO.hh"
#include "DwmIOUtils.hh"
#include "DwmStreamIO.hh"
#include "DwmIpv4Address.hh"
#include "DwmSvnTag.hh"
#include "DwmMcroverWebAlert.hh"
#include "DwmMcroverUtils.hh"

static const Dwm::SvnTag svntag("@(#) $DwmPath: dwm/mcplex/mcrover/tags/mcrover-0.1.7/classes/src/DwmMcroverWebAlert.cc 11886 $");

namespace Dwm {

  namespace Mcrover {

    using namespace std;
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    WebAlert::WebAlert()
        : _uri(), _status(0)
    {}
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    WebAlert::WebAlert(const string & uri, uint16_t status)
        : _uri(uri), _status(status)
    {}
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    const string & WebAlert::URI() const
    {
      return _uri;
    }

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    const string & WebAlert::URI(const string & uri)
    {
      _uri = uri;
      return _uri;
    }

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    const uint16_t & WebAlert::Status() const
    {
      return _status;
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    const uint16_t & WebAlert::Status(uint16_t status)
    {
      _status = status;
      return _status;
    }

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    string WebAlert::DisplayString() const
    {
      return _uri + ':' + to_string(_status) + " WEB";
    }

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    nlohmann::json WebAlert::ToJson() const
    {
      nlohmann::json  j;
      j["uri"] = _uri;
      j["status"] = _status;
      return j;
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    bool WebAlert::FromJson(const nlohmann::json & j)
    {
      bool  rc = false;
      if (j.is_object()) {
        auto  uri = j.find("uri");
        if ((uri != j.end()) && uri->is_string()) {
          _uri = uri->get<string>();
          auto  status = j.find("status");
          if ((status != j.end()) && status->is_number()) {
            _status = status->get<uint16_t>();
            rc = true;
          }
        }
      }
      return rc;
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    istream & WebAlert::Read(istream & is)
    {
      if (Dwm::StreamIO::Read(is, _uri)) {
        Dwm::StreamIO::Read(is, _status);
      }
      return is;
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    ssize_t WebAlert::Read(int fd)
    {
      ssize_t  rc = -1;
      ssize_t  bytesRead = Dwm::DescriptorIO::Read(fd, _uri);
      if (0 < bytesRead) {
        rc = bytesRead;
        bytesRead = Dwm::DescriptorIO::Read(fd, _status);
        if (0 < bytesRead) {
          rc += bytesRead;
        }
        else {
          rc = -1;
        }
      }
      return rc;
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    size_t WebAlert::Read(FILE * f)
    {
      size_t  rc = 0;
      if (Dwm::FileIO::Read(f, _uri)) {
        rc = Dwm::FileIO::Read(f, _status);
      }
      return rc;
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    ostream & WebAlert::Write(ostream & os) const
    {
      if (Dwm::StreamIO::Write(os, _uri)) {
        Dwm::StreamIO::Write(os, _status);
      }
      return os;
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    ssize_t WebAlert::Write(int fd) const
    {
      ssize_t  rc = -1;
      ssize_t  bytesWritten = Dwm::DescriptorIO::Write(fd, _uri);
      if (0 < bytesWritten) {
        rc = bytesWritten;
        bytesWritten = Dwm::DescriptorIO::Write(fd, _status);
        if (0 < bytesWritten) {
          rc += bytesWritten;
        }
        else {
          rc = -1;
        }
      }
      return rc;
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    size_t WebAlert::Write(FILE *f) const
    {
      size_t  rc = 0;
      if (Dwm::FileIO::Write(f, _uri)) {
        rc = Dwm::FileIO::Write(f, _status);
      }
      return rc;
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    uint64_t WebAlert::StreamedLength() const
    {
      return (Dwm::IOUtils::StreamedLength(_uri)
              + Dwm::IOUtils::StreamedLength(_status));
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    bool WebAlert::operator == (const WebAlert & alert) const
    {
      return ((_uri == alert._uri)
              && (_status == alert._status));
    }

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    bool WebAlert::operator < (const WebAlert & alert) const
    {
      bool  rc = false;
      if (_uri < alert._uri) {
        rc = true;
      }
      else if (_uri == alert._uri) {
        if (_status < alert._status) {
          rc = true;
        }
      }
      return rc;
    }
    
    
  }  // namespace Mcrover

}  // namespace Dwm
