//===========================================================================
// @(#) $DwmPath: dwm/mcplex/mcrover/tags/mcrover-0.1.7/classes/tests/DwmMcroverUnitTestUtils.hh 11986 $
// @(#) $Id: DwmMcroverUnitTestUtils.hh 11986 2022-05-09 02:44:39Z dwm $
//===========================================================================
//  Copyright (c) Daniel W. McRobb 2020
//  All rights reserved.
//
//  Redistribution and use in source and binary forms, with or without
//  modification, are permitted provided that the following conditions
//  are met:
//
//  1. Redistributions of source code must retain the above copyright
//     notice, this list of conditions and the following disclaimer.
//  2. Redistributions in binary form must reproduce the above copyright
//     notice, this list of conditions and the following disclaimer in the
//     documentation and/or other materials provided with the distribution.
//  3. The names of the authors and copyright holders may not be used to
//     endorse or promote products derived from this software without
//     specific prior written permission.
//
//  IN NO EVENT SHALL DANIEL W. MCROBB BE LIABLE TO ANY PARTY FOR
//  DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES,
//  INCLUDING LOST PROFITS, ARISING OUT OF THE USE OF THIS SOFTWARE,
//  EVEN IF DANIEL W. MCROBB HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH
//  DAMAGE.
//
//  THE SOFTWARE PROVIDED HEREIN IS ON AN "AS IS" BASIS, AND
//  DANIEL W. MCROBB HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT,
//  UPDATES, ENHANCEMENTS, OR MODIFICATIONS. DANIEL W. MCROBB MAKES NO
//  REPRESENTATIONS AND EXTENDS NO WARRANTIES OF ANY KIND, EITHER
//  IMPLIED OR EXPRESS, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
//  WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE,
//  OR THAT THE USE OF THIS SOFTWARE WILL NOT INFRINGE ANY PATENT,
//  TRADEMARK OR OTHER RIGHTS.
//===========================================================================

//---------------------------------------------------------------------------
//!  \file DwmMcroverUnitTestUtils.hh
//!  \author Daniel W. McRobb
//!  \brief NOT YET DOCUMENTED
//---------------------------------------------------------------------------

#ifndef _DWMMCROVERUNITTESTUTILS_HH_
#define _DWMMCROVERUNITTESTUTILS_HH_

extern "C" {
  #include <fcntl.h>
  #include <unistd.h>
}

#include <cstdio>
#include <sstream>
#include <string>

#include <nlohmann/json.hpp>

#include "DwmUnitAssert.hh"

namespace Dwm {

  namespace Mcrover {

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    class UnitTestUtils
    {
    public:
      //----------------------------------------------------------------------
      //!  
      //----------------------------------------------------------------------
      template <class T>
      static void TestBasicStreamIO(const T & t)
      {
        std::ostringstream  os;
        if (UnitAssert(t.Write(os))) {
          std::istringstream  is(os.str());
          T  t2;
          if (UnitAssert(t2.Read(is))) {
            UnitAssert(t2 == t);
          }
        }
        return;        
      }

      //----------------------------------------------------------------------
      //!  
      //----------------------------------------------------------------------
      template <class T>
      static void TestBasicFileIO(const T & t, const std::string & fileName,
                                  bool removeFileWhenDone = true)
      {
        FILE  *f = fopen(fileName.c_str(), "w");
        if (UnitAssert(f)) {
          UnitAssert(t.Write(f));
          fclose(f);
        }
        f = fopen(fileName.c_str(), "r");
        if (UnitAssert(f)) {
          T  t2;
          if (UnitAssert(t2.Read(f))) {
            UnitAssert(t2 == t);
          }
          fclose(f);
        }
        if (removeFileWhenDone) {
          std::remove(fileName.c_str());
        }
        return;        
      }

      //----------------------------------------------------------------------
      //!  
      //----------------------------------------------------------------------
      template <class T>
      static void TestBasicDescriptorIO(const T & t,
                                        const std::string & fileName,
                                        bool removeFileWhenDone = true)
      {
        int  fd = open(fileName.c_str(), O_CREAT|O_WRONLY|O_TRUNC, 0644);
        if (UnitAssert(0 <= fd)) {
          UnitAssert(t.Write(fd) == t.StreamedLength());
          close(fd);
        }
        fd = open(fileName.c_str(), O_RDONLY);
        if (UnitAssert(0 <= fd)) {
          T  t2;
          ssize_t  bytesRead = t2.Read(fd);
          if (UnitAssert(bytesRead == t.StreamedLength())) {
            UnitAssert(t2 == t);
          }
          else {
            std::cerr << "bytesRead: " << bytesRead << " t.StreamedLength(): "
                      << t.StreamedLength() << '\n';
          }
        }
        if (removeFileWhenDone) {
          std::remove(fileName.c_str());
        }
        return;
      }
      
      //----------------------------------------------------------------------
      //!  
      //----------------------------------------------------------------------
      template <class T>
      static void TestBasicJSON(const T & t)
      {
        nlohmann::json  j = t.ToJson();
        T  t2;
        if (UnitAssert(t2.FromJson(j))) {
          if (! UnitAssert(t2 == t)) {
            std::cerr << j << "\n!=\n" << t2.ToJson() << '\n';
          }
        }
        return;
      }
      
    };
    
          
  }  // namespace Mcrover

}  // namespace Dwm

#endif  // _DWMMCROVERUNITTESTUTILS_HH_
