//===========================================================================
// @(#) $DwmPath: dwm/mcplex/mcrover/tags/mcrover-0.1.7/classes/tests/TestTcp4ConnAlert.cc 10997 $
// @(#) $Id: TestTcp4ConnAlert.cc 10997 2020-08-27 05:34:16Z dwm $
//===========================================================================
//  Copyright (c) Daniel W. McRobb 2020
//  All rights reserved.
//
//  Redistribution and use in source and binary forms, with or without
//  modification, are permitted provided that the following conditions
//  are met:
//
//  1. Redistributions of source code must retain the above copyright
//     notice, this list of conditions and the following disclaimer.
//  2. Redistributions in binary form must reproduce the above copyright
//     notice, this list of conditions and the following disclaimer in the
//     documentation and/or other materials provided with the distribution.
//  3. The names of the authors and copyright holders may not be used to
//     endorse or promote products derived from this software without
//     specific prior written permission.
//
//  IN NO EVENT SHALL DANIEL W. MCROBB BE LIABLE TO ANY PARTY FOR
//  DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES,
//  INCLUDING LOST PROFITS, ARISING OUT OF THE USE OF THIS SOFTWARE,
//  EVEN IF DANIEL W. MCROBB HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH
//  DAMAGE.
//
//  THE SOFTWARE PROVIDED HEREIN IS ON AN "AS IS" BASIS, AND
//  DANIEL W. MCROBB HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT,
//  UPDATES, ENHANCEMENTS, OR MODIFICATIONS. DANIEL W. MCROBB MAKES NO
//  REPRESENTATIONS AND EXTENDS NO WARRANTIES OF ANY KIND, EITHER
//  IMPLIED OR EXPRESS, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
//  WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE,
//  OR THAT THE USE OF THIS SOFTWARE WILL NOT INFRINGE ANY PATENT,
//  TRADEMARK OR OTHER RIGHTS.
//===========================================================================

//---------------------------------------------------------------------------
//!  \file TestTcp4ConnAlert.cc
//!  \author Daniel W. McRobb
//!  \brief NOT YET DOCUMENTED
//---------------------------------------------------------------------------

extern "C" {
  #include <fcntl.h>
  #include <unistd.h>
}

#include <iostream>
#include <sstream>

#include "DwmIpv4Address.hh"
#include "DwmUnitAssert.hh"
#include "DwmMcroverTcp4ConnAlert.hh"
#include "DwmMcroverUnitTestUtils.hh"

using namespace std;
using namespace Dwm;

#define MY_IOTESTFILE "./TestTcp4ConnAlert.tmp"

//----------------------------------------------------------------------------
//!  
//----------------------------------------------------------------------------
static void TestAccessors()
{
  using Mcrover::Tcp4ConnAlert, Mcrover::Tcp4DstAddr;

  Tcp4ConnAlert  alert(Tcp4DstAddr("localhost",
                                   Ipv4Address("127.0.0.1").Raw(),
                                   5050));
  UnitAssert(alert.Destination()
             == Tcp4DstAddr("localhost", Ipv4Address("127.0.0.1").Raw(),
                            5050));

  UnitAssert(alert.Destination(Tcp4DstAddr("somehost",
                                             Ipv4Address("10.1.2.3").Raw(),
                                             6139))
             == Tcp4DstAddr("somehost", Ipv4Address("10.1.2.3").Raw(), 6139));
  UnitAssert(alert.Destination()
             == Tcp4DstAddr("somehost", Ipv4Address("10.1.2.3").Raw(), 6139));

  return;
}

//----------------------------------------------------------------------------
//!  
//----------------------------------------------------------------------------
static void TestBasicIO()
{
  using Mcrover::Tcp4ConnAlert, Mcrover::Tcp4DstAddr;
  
  Tcp4ConnAlert  alert(Tcp4DstAddr("somehost",
                                   Ipv4Address("10.1.2.3").Raw(),
                                   6139));
  Mcrover::UnitTestUtils::TestBasicStreamIO(alert);
  Mcrover::UnitTestUtils::TestBasicFileIO(alert, MY_IOTESTFILE);
  Mcrover::UnitTestUtils::TestBasicDescriptorIO(alert, MY_IOTESTFILE);
  return;
}
      
//----------------------------------------------------------------------------
//!  
//----------------------------------------------------------------------------
static void TestBasicJSON()
{
  using Mcrover::Tcp4ConnAlert, Mcrover::Tcp4DstAddr;

  Tcp4ConnAlert  alert(Tcp4DstAddr("somehost",
                                   Ipv4Address("10.1.2.3").Raw(),
                                   6139));
  Mcrover::UnitTestUtils::TestBasicJSON(alert);
}
      
//----------------------------------------------------------------------------
//!  
//----------------------------------------------------------------------------
int main(int argc, char *argv[])
{
  TestAccessors();
  TestBasicIO();
  TestBasicJSON();
  
  if (Assertions::Total().Failed()) {
    Assertions::Print(cerr, true);
  }
  else {
    cout << Assertions::Total() << " passed" << endl;
  }
  
}
