//===========================================================================
// @(#) $DwmPath: dwm/DwmDns/trunk/classes/src/DwmDnsRRDataRP.cc 10133 $
// @(#) $Id: DwmDnsRRDataRP.cc 10133 2018-01-27 17:41:32Z dwm $
//===========================================================================
//  Copyright (c) Daniel W. McRobb 2018
//  All rights reserved.
//
//  Redistribution and use in source and binary forms, with or without
//  modification, are permitted provided that the following conditions
//  are met:
//
//  1. Redistributions of source code must retain the above copyright
//     notice, this list of conditions and the following disclaimer.
//  2. Redistributions in binary form must reproduce the above copyright
//     notice, this list of conditions and the following disclaimer in the
//     documentation and/or other materials provided with the distribution.
//  3. The names of the authors and copyright holders may not be used to
//     endorse or promote products derived from this software without
//     specific prior written permission.
//
//  IN NO EVENT SHALL DANIEL W. MCROBB BE LIABLE TO ANY PARTY FOR
//  DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES,
//  INCLUDING LOST PROFITS, ARISING OUT OF THE USE OF THIS SOFTWARE,
//  EVEN IF DANIEL W. MCROBB HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH
//  DAMAGE.
//
//  THE SOFTWARE PROVIDED HEREIN IS ON AN "AS IS" BASIS, AND
//  DANIEL W. MCROBB HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT,
//  UPDATES, ENHANCEMENTS, OR MODIFICATIONS. DANIEL W. MCROBB MAKES NO
//  REPRESENTATIONS AND EXTENDS NO WARRANTIES OF ANY KIND, EITHER
//  IMPLIED OR EXPRESS, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
//  WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE,
//  OR THAT THE USE OF THIS SOFTWARE WILL NOT INFRINGE ANY PATENT,
//  TRADEMARK OR OTHER RIGHTS.
//===========================================================================

//---------------------------------------------------------------------------
//!  \file DwmDnsRRDataRP.cc
//!  \brief Dwm::Dns::RRDataRP class implementation
//---------------------------------------------------------------------------

#include "DwmSvnTag.hh"
#include "DwmDnsLabelSequence.hh"
#include "DwmDnsRRDataRP.hh"
#include "DwmDnsUtils.hh"

static const Dwm::SvnTag svntag("@(#) $DwmPath: dwm/DwmDns/trunk/classes/src/DwmDnsRRDataRP.cc 10133 $");

using namespace std;

namespace Dwm {

  namespace Dns {

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    RRDataRP::RRDataRP()
        : _mbox(), _txt()
    {}
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    RRDataRP::RRDataRP(const std::string & mbox, const std::string & txt)
        : _mbox(mbox), _txt(txt)
    {}
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    bool RRDataRP::operator == (const RRDataRP & rp) const
    {
      return ((_mbox == rp._mbox)
              && (_txt == rp._txt));
    }
      
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    const std::string & RRDataRP::Mbox() const
    {
      return _mbox;
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    const std::string & RRDataRP::Mbox(const std::string & mbox)
    {
      _mbox = mbox;
      return _mbox;
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    const std::string & RRDataRP::Txt() const
    {
      return _txt;
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    const std::string & RRDataRP::Txt(const std::string & txt)
    {
      _txt = txt;
      return _txt;
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    uint8_t *RRDataRP::Encode(uint8_t *pkt, uint8_t *ptr,
                              uint16_t pktlen, LabelPositions & lps) const
    {
      LabelSequence  mls(_mbox);
      ptr = mls.Encode(pkt, ptr, pktlen, lps);
      LabelSequence  tls(_txt);
      ptr = tls.Encode(pkt, ptr, pktlen, lps);
      return ptr;
    }

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    const uint8_t *RRDataRP::Decode(const uint8_t *pkt, const uint8_t *ptr,
                                    uint16_t pktlen, uint16_t rdlen)
    {
      _mbox.clear();
      _txt.clear();
      LabelSequence  ls;
      ptr = ls.Decode(pkt, ptr, pktlen);
      _mbox = (string)ls;
      ptr = ls.Decode(pkt, ptr, pktlen);
      _txt = (string)ls;
      return ptr;
    }

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    ostream & operator << (ostream & os, const RRDataRP & rp)
    {
      if (os) {
        os << rp._mbox << ' ' << rp._txt;
      }
      return os;
    }
    

  }  // namespace Dns

}  // namespace Dwm
