//===========================================================================
// @(#) $Name:$
// @(#) $Id: TestTables.cc 9419 2017-06-04 05:08:30Z dwm $
//===========================================================================
//  Copyright (c) Daniel W. McRobb 2017
//  All rights reserved.
//
//  Redistribution and use in source and binary forms, with or without
//  modification, are permitted provided that the following conditions
//  are met:
//
//  1. Redistributions of source code must retain the above copyright
//     notice, this list of conditions and the following disclaimer.
//  2. Redistributions in binary form must reproduce the above copyright
//     notice, this list of conditions and the following disclaimer in the
//     documentation and/or other materials provided with the distribution.
//  3. The names of the authors and copyright holders may not be used to
//     endorse or promote products derived from this software without
//     specific prior written permission.
//
//  IN NO EVENT SHALL DANIEL W. MCROBB BE LIABLE TO ANY PARTY FOR
//  DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES,
//  INCLUDING LOST PROFITS, ARISING OUT OF THE USE OF THIS SOFTWARE,
//  EVEN IF DANIEL W. MCROBB HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH
//  DAMAGE.
//
//  THE SOFTWARE PROVIDED HEREIN IS ON AN "AS IS" BASIS, AND
//  DANIEL W. MCROBB HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT,
//  UPDATES, ENHANCEMENTS, OR MODIFICATIONS. DANIEL W. MCROBB MAKES NO
//  REPRESENTATIONS AND EXTENDS NO WARRANTIES OF ANY KIND, EITHER
//  IMPLIED OR EXPRESS, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
//  WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE,
//  OR THAT THE USE OF THIS SOFTWARE WILL NOT INFRINGE ANY PATENT,
//  TRADEMARK OR OTHER RIGHTS.
//===========================================================================

//---------------------------------------------------------------------------
//!  \file TestTables.cc
//!  \brief NOT YET DOCUMENTED
//---------------------------------------------------------------------------

extern "C" {
  #include <unistd.h>
}

#include <iomanip>
#include <iostream>

#include "DwmSysLogger.hh"
#include "DwmUnitAssert.hh"

#include "DwmPfDevice.hh"

using namespace std;
using namespace Dwm;

//----------------------------------------------------------------------------
//!  
//----------------------------------------------------------------------------
int main(int argc, char *argv[])
{
#if 0
  SysLogger::Open("TestTables", LOG_PID|LOG_PERROR, LOG_USER);
  SysLogger::ShowPriorities(true);
  SysLogger::ShowFileLocation(true);
#endif
  
  Pf::Device  pfdev("/dev/pf");
  if (UnitAssert(pfdev.Open())) {
    UnitAssert(pfdev.CreateTable("", "foo"));
    UnitAssert(pfdev.TableExists(Pf::Table(pfdev, "", "foo")));
    Pf::Table  && foo = pfdev.GetTable("", "foo");
    UnitAssert(foo.Anchor() == "");
    UnitAssert(foo.Name() == "foo");

    Ipv4Prefix  respfx;
    UnitAssert(foo.Add(Ipv4Prefix("10.11.12.13/32")));
    UnitAssert(foo.Contains(Ipv4Prefix("10.11.12.13/32"), respfx));
    UnitAssert(! foo.Add(Ipv4Prefix("10.11.12.13/32")));
    UnitAssert(foo.Remove(Ipv4Prefix("10.11.12.13/32")));
    UnitAssert(! foo.Remove(Ipv4Prefix("10.11.12.13/32")));

    UnitAssert(foo.Add(Ipv4Prefix("10.11.12/24")));
    UnitAssert(foo.Contains(Ipv4Prefix("10.11.12/24"), respfx));
    UnitAssert(foo.Contains(Ipv4Prefix("10.11.12.13/32"), respfx));
    UnitAssert(respfx == Ipv4Prefix("10.11.12/24"));
    cerr << "respfx: " << respfx << '\n';
    UnitAssert(! foo.Contains(Ipv4Prefix("10.11.100.13/32"), respfx));
    UnitAssert(foo.Remove(Ipv4Prefix("10.11.12/24")));
    UnitAssert(foo.Persist(true));
    UnitAssert(foo.Persist());
    UnitAssert(foo.Constant(true));
    UnitAssert(foo.Constant());
    UnitAssert(! foo.Add(Ipv4Prefix("10.11.12/24")));
    UnitAssert(foo.Constant(false));
    UnitAssert(! foo.Constant());
    UnitAssert(foo.Add(Ipv4Prefix("10.11.12/24")));
    sleep(20);
    UnitAssert(foo.Remove(Ipv4Prefix("10.11.12/24")));

#ifndef __APPLE__
    UnitAssert(foo.CountersEnabled(true));
    UnitAssert(foo.CountersEnabled());
    UnitAssert(foo.CountersEnabled(false));
    UnitAssert(! foo.CountersEnabled());
#endif
    
    vector<Pf::Table>  && tables = pfdev.GetTables();
    UnitAssert(! tables.empty());
    UnitAssert(pfdev.DeleteTable("", "foo"));
    UnitAssert(! pfdev.TableExists(Pf::Table(pfdev, "", "foo")));
    // UnitAssert(foo.Persist(false));
    UnitAssert(! foo.Persist());

#if 0
    Pf::Table  losersTable = pfdev.GetTable("", "losers");
    if (UnitAssert(losersTable.Name() == "losers")) {
      vector<Pf::TableEntryStat>  && stats = losersTable.GetStats();
      UnitAssert(! stats.empty());
#ifndef __APPLE__
      UnitAssert(losersTable.CountersEnabled());
#endif
      
      for (auto s : stats) {
        cout << setw(18) << s.Prefix() << ' '
             << setw(10) << s.InPktsBlocked() << ' '
             << setw(10) << s.InBytesBlocked() << ' '
             << setw(10) << s.OutPktsBlocked() << ' '
             << setw(10) << s.OutBytesBlocked() << '\n';
      }
    }
#endif
    pfdev.Close();
  }
  
  if (Assertions::Total().Failed() > 0) {
    Assertions::Print(cerr, true);
    return(1);
  }
  else {
    cout << Dwm::Assertions::Total() << " passed\n";
  }

}
