//===========================================================================
// @(#) $Name:$
// @(#) $Id: rdapjson2db.cc 12077 2022-11-25 18:56:56Z dwm $
//===========================================================================
//  Copyright (c) Daniel W. McRobb 2017
//  All rights reserved.
//
//  Redistribution and use in source and binary forms, with or without
//  modification, are permitted provided that the following conditions
//  are met:
//
//  1. Redistributions of source code must retain the above copyright
//     notice, this list of conditions and the following disclaimer.
//  2. Redistributions in binary form must reproduce the above copyright
//     notice, this list of conditions and the following disclaimer in the
//     documentation and/or other materials provided with the distribution.
//  3. The names of the authors and copyright holders may not be used to
//     endorse or promote products derived from this software without
//     specific prior written permission.
//
//  IN NO EVENT SHALL DANIEL W. MCROBB BE LIABLE TO ANY PARTY FOR
//  DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES,
//  INCLUDING LOST PROFITS, ARISING OUT OF THE USE OF THIS SOFTWARE,
//  EVEN IF DANIEL W. MCROBB HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH
//  DAMAGE.
//
//  THE SOFTWARE PROVIDED HEREIN IS ON AN "AS IS" BASIS, AND
//  DANIEL W. MCROBB HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT,
//  UPDATES, ENHANCEMENTS, OR MODIFICATIONS. DANIEL W. MCROBB MAKES NO
//  REPRESENTATIONS AND EXTENDS NO WARRANTIES OF ANY KIND, EITHER
//  IMPLIED OR EXPRESS, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
//  WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE,
//  OR THAT THE USE OF THIS SOFTWARE WILL NOT INFRINGE ANY PATENT,
//  TRADEMARK OR OTHER RIGHTS.
//===========================================================================

//---------------------------------------------------------------------------
//!  \file rdapjson2db.cc
//!  \brief NOT YET DOCUMENTED
//---------------------------------------------------------------------------

#include <fstream>

#include "DwmDateTime.hh"
#include "DwmSvnTag.hh"
#include "DwmIpv4CountryDb.hh"

static const Dwm::SvnTag svntag("@(#) $DwmPath: dwm/libDwmRDAP/trunk/apps/rdapjson2db/rdapjson2db.cc 12077 $");

using namespace std;
using namespace Dwm;

//----------------------------------------------------------------------------
//!  
//----------------------------------------------------------------------------
int main(int argc, char *argv[])
{
  if (argc != 3) {
    cerr << "Usage: " << argv[0] << " jsonfile dbfile\n";
    return 1;
  }
  
  ifstream  is(argv[1]);
  if (is) {
    Dwm::Ipv4CountryDb countrydb(argv[2]);
    nlohmann::json  jv = nlohmann::json::parse(is, nullptr, false);
    if (! jv.is_discarded()) {
      for (int i = 0; i < jv.size(); ++i) {
        DateTime  dt(Dwm::TimeValue64(0,0));
        if ((jv[i].find("lastChanged") != jv[i].end())) {
          dt.Parse(jv[i]["lastChanged"].get<string>(), "%Y-%m-%d %H:%M");
        }
        Ipv4CountryDbValue  value(jv[i]["country"].get<string>(),
                                  dt.GetTimeValue64());
        ((RDAP::Ipv4Routes<Ipv4CountryDbValue> &)countrydb).Add(Ipv4Prefix(jv[i]["prefix"].get<string>()), value);
      }
      countrydb.Save();
    }
  }
  return 0;
}
