//===========================================================================
// @(#) $DwmPath$
//===========================================================================
//  Copyright (c) Daniel W. McRobb 2024
//  All rights reserved.
//
//  Redistribution and use in source and binary forms, with or without
//  modification, are permitted provided that the following conditions
//  are met:
//
//  1. Redistributions of source code must retain the above copyright
//     notice, this list of conditions and the following disclaimer.
//  2. Redistributions in binary form must reproduce the above copyright
//     notice, this list of conditions and the following disclaimer in the
//     documentation and/or other materials provided with the distribution.
//  3. The names of the authors and copyright holders may not be used to
//     endorse or promote products derived from this software without
//     specific prior written permission.
//
//  IN NO EVENT SHALL DANIEL W. MCROBB BE LIABLE TO ANY PARTY FOR
//  DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES,
//  INCLUDING LOST PROFITS, ARISING OUT OF THE USE OF THIS SOFTWARE,
//  EVEN IF DANIEL W. MCROBB HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH
//  DAMAGE.
//
//  THE SOFTWARE PROVIDED HEREIN IS ON AN "AS IS" BASIS, AND
//  DANIEL W. MCROBB HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT,
//  UPDATES, ENHANCEMENTS, OR MODIFICATIONS. DANIEL W. MCROBB MAKES NO
//  REPRESENTATIONS AND EXTENDS NO WARRANTIES OF ANY KIND, EITHER
//  IMPLIED OR EXPRESS, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
//  WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE,
//  OR THAT THE USE OF THIS SOFTWARE WILL NOT INFRINGE ANY PATENT,
//  TRADEMARK OR OTHER RIGHTS.
//===========================================================================

//---------------------------------------------------------------------------
//!  \file DwmMcCurtainRipeAsnTxt.cc
//!  \author Daniel W. McRobb
//!  \brief Dwm::McCurtain::RipeAsnTxt class implementation
//---------------------------------------------------------------------------

#include <fstream>

#include "DwmStreamIO.hh"
#include "DwmSysLogger.hh"
#include "DwmMcCurtainRipeAsnTxt.hh"

namespace Dwm {

  namespace McCurtain {

    using namespace std;

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    std::istream & RipeAsnTxt::Entry::Read(std::istream & is)
    {
      if (StreamIO::Read(is, _asName)) {
        StreamIO::Read(is, _countryCode);
      }
      return is;
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    std::ostream & RipeAsnTxt::Entry::Write(std::ostream & os) const
    {
      if (StreamIO::Write(os, _asName)) {
        StreamIO::Write(os, _countryCode);
      }
      return os;
    }

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    bool RipeAsnTxt::Load(const std::string & asntxtFile)
    {
      _entries.clear();
      ifstream  is(asntxtFile);
      while (is) {
        string  linestr;
        if (std::getline(is, linestr)) {
          string::size_type  idx = linestr.find_first_of(' ');
          if (idx && (idx != string::npos)) {
            uint32_t  asNum = stoul(linestr.substr(0,idx), nullptr, 10);
            string::size_type  idx2 = linestr.find_last_of(',');
            if ((idx2 != string::npos) && ((idx2 + 3) < linestr.size())) {
              Entry  entry(linestr.substr(idx + 1, (idx2 - idx) - 1),
                           linestr.substr(idx2 + 2, 2));
              _entries[asNum] = entry;
            }
#if 0
            else {
              Syslog(LOG_ERR, "Failed to parse name and country code\n");
              goto parseFailed;
            }
#endif
          }
          else {
            goto parseFailed;
          }
        }
      }
      return (! _entries.empty());

    parseFailed:
      _entries.clear();
      return false;
    }
    
    
  }  // namespace McCurtain

}  // namespace Dwm
