//===========================================================================
// @(#) $DwmPath: dwm/mcplex/mcrover/tags/mcrover-0.1.13/apps/mcrover/DwmMcroverAlertsWindow.hh 11886 $
// @(#) $Id: DwmMcroverAlertsWindow.hh 11886 2021-04-07 05:16:39Z dwm $
//===========================================================================
//  Copyright (c) Daniel W. McRobb 2020
//  All rights reserved.
//
//  Redistribution and use in source and binary forms, with or without
//  modification, are permitted provided that the following conditions
//  are met:
//
//  1. Redistributions of source code must retain the above copyright
//     notice, this list of conditions and the following disclaimer.
//  2. Redistributions in binary form must reproduce the above copyright
//     notice, this list of conditions and the following disclaimer in the
//     documentation and/or other materials provided with the distribution.
//  3. The names of the authors and copyright holders may not be used to
//     endorse or promote products derived from this software without
//     specific prior written permission.
//
//  IN NO EVENT SHALL DANIEL W. MCROBB BE LIABLE TO ANY PARTY FOR
//  DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES,
//  INCLUDING LOST PROFITS, ARISING OUT OF THE USE OF THIS SOFTWARE,
//  EVEN IF DANIEL W. MCROBB HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH
//  DAMAGE.
//
//  THE SOFTWARE PROVIDED HEREIN IS ON AN "AS IS" BASIS, AND
//  DANIEL W. MCROBB HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT,
//  UPDATES, ENHANCEMENTS, OR MODIFICATIONS. DANIEL W. MCROBB MAKES NO
//  REPRESENTATIONS AND EXTENDS NO WARRANTIES OF ANY KIND, EITHER
//  IMPLIED OR EXPRESS, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
//  WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE,
//  OR THAT THE USE OF THIS SOFTWARE WILL NOT INFRINGE ANY PATENT,
//  TRADEMARK OR OTHER RIGHTS.
//===========================================================================

//---------------------------------------------------------------------------
//!  \file DwmMcroverAlertsWindow.hh
//!  \author Daniel W. McRobb
//!  \brief NOT YET DOCUMENTED
//---------------------------------------------------------------------------

#ifndef _DWMMCROVERALERTSWINDOW_HH_
#define _DWMMCROVERALERTSWINDOW_HH_

#include <string>
#include <vector>

#include "DwmMcroverAlertBowl.hh"

extern "C" {
  #include <curses.h>
}

namespace Dwm {

  namespace Mcrover {

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    class AlertsWindow
    {
    public:
      //----------------------------------------------------------------------
      //!  
      //----------------------------------------------------------------------
      AlertsWindow();

      //----------------------------------------------------------------------
      //!  
      //----------------------------------------------------------------------
      ~AlertsWindow();

      //----------------------------------------------------------------------
      //!  
      //----------------------------------------------------------------------
      void
      Update(const std::vector<std::pair<AlertBowl::KeyType,AlertBowlValue>> & alerts);
      
      //----------------------------------------------------------------------
      //!  
      //----------------------------------------------------------------------
      void Resize();

      void Scroll(int amt);
      void ScrollPage(int pages);

    private:
      WINDOW  *_win;
      int      _contentLength;
      int      _scrollPos;
      
      int DrawAsciiArt();
      void DrawAlertLine(const std::string & alert, int line);
    };
    
  }  // namespace Mcrover

}  // namespace Dwm

#endif  // _DWMMCROVERALERTSWINDOW_HH_
