//===========================================================================
// @(#) $DwmPath: dwm/mcplex/mcrover/tags/mcrover-0.1.13/apps/mcrover/DwmMcroverFelix1.cc 10997 $
// @(#) $Id: DwmMcroverFelix1.cc 10997 2020-08-27 05:34:16Z dwm $
//===========================================================================
//  Copyright (c) Daniel W. McRobb 2020
//  All rights reserved.
//
//  Redistribution and use in source and binary forms, with or without
//  modification, are permitted provided that the following conditions
//  are met:
//
//  1. Redistributions of source code must retain the above copyright
//     notice, this list of conditions and the following disclaimer.
//  2. Redistributions in binary form must reproduce the above copyright
//     notice, this list of conditions and the following disclaimer in the
//     documentation and/or other materials provided with the distribution.
//  3. The names of the authors and copyright holders may not be used to
//     endorse or promote products derived from this software without
//     specific prior written permission.
//
//  IN NO EVENT SHALL DANIEL W. MCROBB BE LIABLE TO ANY PARTY FOR
//  DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES,
//  INCLUDING LOST PROFITS, ARISING OUT OF THE USE OF THIS SOFTWARE,
//  EVEN IF DANIEL W. MCROBB HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH
//  DAMAGE.
//
//  THE SOFTWARE PROVIDED HEREIN IS ON AN "AS IS" BASIS, AND
//  DANIEL W. MCROBB HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT,
//  UPDATES, ENHANCEMENTS, OR MODIFICATIONS. DANIEL W. MCROBB MAKES NO
//  REPRESENTATIONS AND EXTENDS NO WARRANTIES OF ANY KIND, EITHER
//  IMPLIED OR EXPRESS, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
//  WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE,
//  OR THAT THE USE OF THIS SOFTWARE WILL NOT INFRINGE ANY PATENT,
//  TRADEMARK OR OTHER RIGHTS.
//===========================================================================

//---------------------------------------------------------------------------
//!  \file DwmMcroverFelix1.cc
//!  \author Daniel W. McRobb
//!  \brief NOT YET DOCUMENTED
//---------------------------------------------------------------------------

#include <algorithm>
#include <vector>

#include "DwmMcroverColorPairs.hh"
#include "DwmMcroverFelix1.hh"

namespace Dwm {

  namespace Mcrover {

    using namespace std;
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    static const vector<string>  g_felix1 = {
      R"(              iWs                                 ,W[)",
      R"(              W@@W.                              g@@[)",
      R"(             i@@@@@s                           g@@@@W)",
      R"(             @@@@@@@W.                       ,W@@@@@@)",
      R"(            ]@@@@@@@@@W.   ,_______.       ,m@@@@@@@@i)",
      R"(           ,@@@@@@@@@@@@W@@@@@@@@@@@@@@mm_g@@@@@@@@@@[)",
      R"(           d@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@)",
      R"(          i@@@@@@@A*~~~~~VM@@@@@@@@@@Af~~~~V*@@@@@@@@@i)",
      R"(          @@@@@A~          'M@@@@@@A`         'V@@@@@@b)",
      R"(         d@@@*`              Y@@@@f              V@@@@@.)",
      R"(        i@@A`                 M@@P                 V@@@b)",
      R"(       ,@@A                   '@@                   !@@@.)",
      R"(       W@P                     @[                    '@@W)",
      R"(      d@@            ,         ]!                     ]@@b)",
      R"(     g@@[          ,W@@s       ]       ,W@@s           @@@i)",
      R"(    i@@@[          W@@@@i      ]       W@@@@i          @@@@i)",
      R"(   i@@@@[          @@@@@[      ]       @@@@@[          @@@@@i)",
      R"(  g@@@@@[          @@@@@!      @[      @@@@@[          @@@@@@i)",
      R"( d@@@@@@@          !@@@P      iAW      !@@@A          ]@@@@@@@i)",
      R"(W@@@@@@@@b          '~~      ,Z Yi      '~~          ,@@@@@@@@@)",
      R"('*@@@@@@@@s                  Z`  Y.                 ,W@@@@@@@@A)",
      R"(  'M@@@*f**W.              ,Z     Vs               ,W*~~~M@@@f)",
      R"(    'M@    'Vs.          ,z~       'N_           ,Z~     d@P)",
      R"(   M@@@       ~\-__  __z/` ,gmW@@mm_ '+e_.   __=/`      ,@@@@)",
      R"(    'VMW                  g@@@@@@@@@W     ~~~          ,WAf)",
      R"(       ~N.                @@@@@@@@@@@!                ,Z`)",
      R"(         V.               !M@@@@@@@@f                gf-)",
      R"(          'N.               '~***f~                ,Z`)",
      R"(            Vc.                                  _Zf)",
      R"(              ~e_                             ,gY~)",
      R"(                'V=_          -@@D         ,gY~ ')",
      R"(                    ~\=__.           ,__z=~`)",
      R"(                         '~~~*==Y*f~~~)"
    };

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    int Felix1::Width() const
    {
      return max_element(g_felix1.begin(), g_felix1.end(),
                         [] (const string & a, const string & b)
                         { return (a.size() < b.size()); })->size();
    }

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    int Felix1::Height() const
    {
      return g_felix1.size();
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    void Felix1::Draw(WINDOW *win) const
    {
      if (win) {
        auto [origy, origx] = Position(win);
        wattrset(win, COLOR_PAIR(ColorPairs::Pair("white"))|A_BOLD);
        for (int ln = 0; ln < g_felix1.size(); ++ln) {
          mvwaddstr(win, origy + ln, origx, g_felix1[ln].c_str());
          wclrtoeol(win);
        }
      }
      
      return;
    }
    

  }  // namespace Mcrover

}  // namespace Dwm
