//===========================================================================
// @(#) $DwmPath: dwm/mcplex/mcrover/tags/mcrover-0.1.13/apps/mcrover/DwmMcroverSnoopy2.cc 10997 $
// @(#) $Id: DwmMcroverSnoopy2.cc 10997 2020-08-27 05:34:16Z dwm $
//===========================================================================
//  Copyright (c) Daniel W. McRobb 2020
//  All rights reserved.
//
//  Redistribution and use in source and binary forms, with or without
//  modification, are permitted provided that the following conditions
//  are met:
//
//  1. Redistributions of source code must retain the above copyright
//     notice, this list of conditions and the following disclaimer.
//  2. Redistributions in binary form must reproduce the above copyright
//     notice, this list of conditions and the following disclaimer in the
//     documentation and/or other materials provided with the distribution.
//  3. The names of the authors and copyright holders may not be used to
//     endorse or promote products derived from this software without
//     specific prior written permission.
//
//  IN NO EVENT SHALL DANIEL W. MCROBB BE LIABLE TO ANY PARTY FOR
//  DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES,
//  INCLUDING LOST PROFITS, ARISING OUT OF THE USE OF THIS SOFTWARE,
//  EVEN IF DANIEL W. MCROBB HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH
//  DAMAGE.
//
//  THE SOFTWARE PROVIDED HEREIN IS ON AN "AS IS" BASIS, AND
//  DANIEL W. MCROBB HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT,
//  UPDATES, ENHANCEMENTS, OR MODIFICATIONS. DANIEL W. MCROBB MAKES NO
//  REPRESENTATIONS AND EXTENDS NO WARRANTIES OF ANY KIND, EITHER
//  IMPLIED OR EXPRESS, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
//  WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE,
//  OR THAT THE USE OF THIS SOFTWARE WILL NOT INFRINGE ANY PATENT,
//  TRADEMARK OR OTHER RIGHTS.
//===========================================================================

//---------------------------------------------------------------------------
//!  \file DwmMcroverSnoopy2.cc
//!  \author Daniel W. McRobb
//!  \brief NOT YET DOCUMENTED
//---------------------------------------------------------------------------

#include <algorithm>
#include <vector>

#include "DwmSysLogger.hh"
#include "DwmMcroverColorPairs.hh"
#include "DwmMcroverSnoopy2.hh"

namespace Dwm {

  namespace Mcrover {

    using namespace std;
    
    static const vector<string>  g_snoopy2 = {
      R"(              XXXX)",
      R"(             X    XX)",
      R"(            X  ***  X                XXXXX)",
      R"(           X  *****  X            XXX     XX)",
      R"(        XXXX ******* XXX      XXXX          XX)",
      R"(      XX   X ******  XXXXXXXXX                XX XXX)",
      R"(    XX      X ****  X                           X** X)",
      R"(   X        XX    XX     X                      X***X)",
      R"(  X         //XXXX       X                      XXXX)",
      R"( X         //   X                             XX)",
      R"(X         //    X          XXXXXXXXXXXXXXXXXX/)",
      R"(X     XXX//    X          X)",
      R"(X    X   X     X         X)",
      R"(X    X    X    X        X)",
      R"( X   X    X    X        X                    XX)",
      R"( X    X   X    X        X                 XXX  XX)",
      R"(  X    XXX      X        X               X  X X  X)",
      R"(  X             X         X              XX X  XXXX)",
      R"(   X             X         XXXXXXXX\     XX   XX  X)",
      R"(    XX            XX              X     X    X  XX)",
      R"(      XX            XXXX   XXXXXX/     X     XXXX)",
      R"(        XXX             XX***         X     X)",
      R"(           XXXXXXXXXXXXX *   *       X     X)",
      R"(                        *---* X     X     X)",
      R"(                       *-* *   XXX X     X)",
      R"(                       *- *       XXX   X)",
      R"(                      *- *X          XXX)",
      R"(                      *- *X  X          XXX)",
      R"(                     *- *X    X            XX)",
      R"(                     *- *XX    X             X)",
      R"(                    *  *X* X    X             X)",
      R"(                    *  *X * X    X             X)",
      R"(                   *  * X**  X   XXXX          X)",
      R"(                   *  * X**  XX     X          X)",
      R"(                  *  ** X** X     XX          X)",
      R"(                  *  **  X*  XXX   X         X)",
      R"(                 *  **    XX   XXXX       XXX)",
      R"(                *  * *      XXXX      X     X)",
      R"(               *   * *          X     X     X)",
      R"( =======*******   * *           X     X      XXXXXXXX\)",
      R"(        *         * *      /XXXXX      XXXXXXXX\      ))",
      R"(   =====**********  *     X                     )  \  ))",
      R"(     ====*         *     X               \  \   )XXXXX)",
      R"(=========**********       XXXXXXXXXXXXXXXXXXXXXX)"
    };

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    int Snoopy2::Width() const
    {
      return max_element(g_snoopy2.begin(), g_snoopy2.end(),
                         [] (const string & a, const string & b)
                         { return (a.size() < b.size()); })->size();
    }

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    int Snoopy2::Height() const
    {
      return g_snoopy2.size();
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    void Snoopy2::Draw(WINDOW *win) const
    {
      if (win) {
        auto [origy, origx] = Position(win);
        Syslog(LOG_INFO, "origy: %d origx: %d", origy, origx);
        for (int ln = 0; ln < g_snoopy2.size(); ++ln) {
          mvwaddstr(win, origy + ln, origx, g_snoopy2[ln].c_str());
          wclrtoeol(win);
        }
        int  brown = ColorPairs::Pair("brown");
        int  olive = ColorPairs::Pair("olive");
        int  cyan = ColorPairs::Pair("cyan");
        int  red = ColorPairs::Pair("brightred");

        if (COLORS < 16) {
          brown = ColorPairs::Pair("blue");
          olive = ColorPairs::Pair("green");
          red = ColorPairs::Pair("red");
        }
        
        mvwchgat(win, origy,   origx,    -1, A_NORMAL, brown, nullptr);
        mvwchgat(win, origy+1, origx,    -1, A_NORMAL, brown, nullptr);
        mvwchgat(win, origy+2, origx,    13, A_NORMAL, brown, nullptr);
        mvwchgat(win, origy+2, origx+13,  5, A_NORMAL, cyan, nullptr);
        mvwchgat(win, origy+2, origx+20,  1, A_NORMAL, brown, nullptr);

        mvwchgat(win, origy+3, origx,    11, A_NORMAL, brown, nullptr);
        mvwchgat(win, origy+3, origx+11,  1, A_NORMAL, brown, nullptr);
        mvwchgat(win, origy+3, origx+14,  7, A_NORMAL, cyan, nullptr);
        mvwchgat(win, origy+3, origx+21,  1, A_NORMAL, brown, nullptr);
        mvwchgat(win, origy+3, origx+22,  1, A_NORMAL, olive, nullptr);

        mvwchgat(win, origy+4, origx,    11, A_NORMAL, olive, nullptr);
        mvwchgat(win, origy+4, origx+11,  1, A_NORMAL, brown, nullptr);
        mvwchgat(win, origy+4, origx+13,  7, A_NORMAL, cyan, nullptr);
        mvwchgat(win, origy+4, origx+21,  1, A_NORMAL, brown, nullptr);
        mvwchgat(win, origy+4, origx+22,  2, A_NORMAL, olive, nullptr);

        mvwchgat(win, origy+5, origx,    11, A_NORMAL, olive, nullptr);
        mvwchgat(win, origy+5, origx+11,  1, A_NORMAL, brown, nullptr);
        mvwchgat(win, origy+5, origx+13,  6, A_NORMAL, cyan, nullptr);
        mvwchgat(win, origy+5, origx+21,  1, A_NORMAL, brown, nullptr);

        mvwchgat(win, origy+6, origx,    11, A_NORMAL, olive, nullptr);
        mvwchgat(win, origy+6, origx+12,  1, A_NORMAL, brown, nullptr);
        mvwchgat(win, origy+6, origx+14,  4, A_NORMAL, cyan, nullptr);
        mvwchgat(win, origy+6, origx+20,  1, A_NORMAL, brown, nullptr);

        mvwchgat(win, origy+7, origx,    11, A_NORMAL, olive, nullptr);
        mvwchgat(win, origy+7, origx+12,  8, A_NORMAL, brown, nullptr);

        mvwchgat(win, origy+8, origx,     3, A_NORMAL, olive, nullptr);
        mvwchgat(win, origy+8, origx+12,  6, A_NORMAL, brown, nullptr);

        mvwchgat(win, origy+9, origx,     2, A_NORMAL, olive, nullptr);
        mvwchgat(win, origy+9, origx+11,  2, A_NORMAL, brown, nullptr);
        mvwchgat(win, origy+9, origx+16,  1, A_NORMAL, olive, nullptr);

        mvwchgat(win, origy+10, origx,     1, A_NORMAL, olive, nullptr);
        mvwchgat(win, origy+10, origx+10,  2, A_NORMAL, brown, nullptr);
        mvwchgat(win, origy+10, origx+16,  1, A_NORMAL, olive, nullptr);

        mvwchgat(win, origy+11, origx,     1, A_NORMAL, olive, nullptr);
        mvwchgat(win, origy+11, origx+6,   5, A_NORMAL, brown, nullptr);
        mvwchgat(win, origy+11, origx+15,  1, A_NORMAL, olive, nullptr);

        mvwchgat(win, origy+12, origx,     1, A_NORMAL, olive, nullptr);
        mvwchgat(win, origy+12, origx+5,   5, A_NORMAL, brown, nullptr);
        mvwchgat(win, origy+12, origx+15,  1, A_NORMAL, olive, nullptr);

        mvwchgat(win, origy+13, origx,     1, A_NORMAL, olive, nullptr);
        mvwchgat(win, origy+13, origx+5,   6, A_NORMAL, brown, nullptr);
        mvwchgat(win, origy+13, origx+15,  1, A_NORMAL, olive, nullptr);

        mvwchgat(win, origy+14, origx+1,   1, A_NORMAL, olive, nullptr);
        mvwchgat(win, origy+14, origx+5,   6, A_NORMAL, brown, nullptr);
        mvwchgat(win, origy+14, origx+15,  1, A_NORMAL, olive, nullptr);

        mvwchgat(win, origy+15, origx+1,   1, A_NORMAL, olive, nullptr);
        mvwchgat(win, origy+15, origx+6,   5, A_NORMAL, brown, nullptr);
        mvwchgat(win, origy+15, origx+15,  1, A_NORMAL, olive, nullptr);

        mvwchgat(win, origy+16, origx+2,   1, A_NORMAL, olive, nullptr);
        mvwchgat(win, origy+16, origx+7,   3, A_NORMAL, brown, nullptr);
        mvwchgat(win, origy+16, origx+16,  1, A_NORMAL, olive, nullptr);

        mvwchgat(win, origy+17, origx+2,   1, A_NORMAL, olive, nullptr);
        mvwchgat(win, origy+17, origx+16,  1, A_NORMAL, olive, nullptr);

        mvwchgat(win, origy+18, origx+3,   1, A_NORMAL, olive, nullptr);
        mvwchgat(win, origy+18, origx+17,  1, A_NORMAL, olive, nullptr);

        mvwchgat(win, origy+19, origx+4,   2, A_NORMAL, olive, nullptr);
        mvwchgat(win, origy+19, origx+18,  2, A_NORMAL, olive, nullptr);

        mvwchgat(win, origy+20, origx+6,   2, A_NORMAL, olive, nullptr);
        mvwchgat(win, origy+20, origx+20,  4, A_NORMAL, olive, nullptr);

        mvwchgat(win, origy+21, origx+8,   3, A_NORMAL, olive, nullptr);
        mvwchgat(win, origy+21, origx+24,  2, A_NORMAL, olive, nullptr);
        mvwchgat(win, origy+21, origx+26,  3, A_NORMAL,  red, nullptr);

        mvwchgat(win, origy+22, origx+11,  13, A_NORMAL, olive, nullptr);
        mvwchgat(win, origy+22, origx+25,   5, A_NORMAL,  red, nullptr);

        mvwchgat(win, origy+23, origx+24,   5, A_NORMAL,  red, nullptr);

        mvwchgat(win, origy+24, origx+23,   5, A_NORMAL,  red, nullptr);

        mvwchgat(win, origy+25, origx+23,   4, A_NORMAL,  red, nullptr);

        mvwchgat(win, origy+26, origx+22,   4, A_NORMAL,  red, nullptr);

        mvwchgat(win, origy+27, origx+22,   4, A_NORMAL,  red, nullptr);

        mvwchgat(win, origy+28, origx+21,   4, A_NORMAL,  red, nullptr);

        mvwchgat(win, origy+29, origx+21,   4, A_NORMAL,  red, nullptr);

        for (int rr = 30; rr < Height() + 1; ++rr) {
          mvwchgat(win, origy + rr, origx, 24, A_NORMAL,  red, nullptr);
        }
        
      }
      return;
    }
    
  }  // namespace Mcrover

}  // namespace Dwm
