//===========================================================================
// @(#) $DwmPath: dwm/mcplex/mcrover/tags/mcrover-0.1.13/apps/mcrover/DwmMcroverTitleWindow.cc 10997 $
// @(#) $Id: DwmMcroverTitleWindow.cc 10997 2020-08-27 05:34:16Z dwm $
//===========================================================================
//  Copyright (c) Daniel W. McRobb 2020
//  All rights reserved.
//
//  Redistribution and use in source and binary forms, with or without
//  modification, are permitted provided that the following conditions
//  are met:
//
//  1. Redistributions of source code must retain the above copyright
//     notice, this list of conditions and the following disclaimer.
//  2. Redistributions in binary form must reproduce the above copyright
//     notice, this list of conditions and the following disclaimer in the
//     documentation and/or other materials provided with the distribution.
//  3. The names of the authors and copyright holders may not be used to
//     endorse or promote products derived from this software without
//     specific prior written permission.
//
//  IN NO EVENT SHALL DANIEL W. MCROBB BE LIABLE TO ANY PARTY FOR
//  DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES,
//  INCLUDING LOST PROFITS, ARISING OUT OF THE USE OF THIS SOFTWARE,
//  EVEN IF DANIEL W. MCROBB HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH
//  DAMAGE.
//
//  THE SOFTWARE PROVIDED HEREIN IS ON AN "AS IS" BASIS, AND
//  DANIEL W. MCROBB HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT,
//  UPDATES, ENHANCEMENTS, OR MODIFICATIONS. DANIEL W. MCROBB MAKES NO
//  REPRESENTATIONS AND EXTENDS NO WARRANTIES OF ANY KIND, EITHER
//  IMPLIED OR EXPRESS, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
//  WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE,
//  OR THAT THE USE OF THIS SOFTWARE WILL NOT INFRINGE ANY PATENT,
//  TRADEMARK OR OTHER RIGHTS.
//===========================================================================

//---------------------------------------------------------------------------
//!  \file DwmMcroverTitleWindow.cc
//!  \author Daniel W. McRobb
//!  \brief NOT YET DOCUMENTED
//---------------------------------------------------------------------------

#include <cstring>

#include "DwmDateTime.hh"
#include "DwmSvnTag.hh"
#include "DwmMcroverColorPairs.hh"
#include "DwmMcroverTitleWindow.hh"

static const Dwm::SvnTag svntag("@(#) $DwmPath: dwm/mcplex/mcrover/tags/mcrover-0.1.13/apps/mcrover/DwmMcroverTitleWindow.cc 10997 $");

namespace Dwm {

  namespace Mcrover {

    using namespace std;
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    TitleWindow::TitleWindow()
    {
      _win = newwin(1, COLS, 0, 0);
      if (COLORS < 16) {
        wattrset(_win,
                 COLOR_PAIR(ColorPairs::Pair("yellow/blue"))
                 | A_BOLD | A_UNDERLINE);
      }
      else {
        wattrset(_win,
                 COLOR_PAIR(ColorPairs::Pair("btyellow/blue"))
                 | A_BOLD | A_UNDERLINE);
      }
      
      string  ws((COLS / 2) - 15, ' ');
      mvwaddstr(_win, 0, 11, ws.c_str());
      mvwaddstr(_win, 0, (COLS / 2) - 4, "mcrover");
      string  ws2(COLS - (COLS / 2) + 3, ' ');
      mvwaddstr(_win, 0, (COLS / 2) + 3, ws2.c_str());
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    TitleWindow::~TitleWindow()
    {
      if (_win) {
        delwin(_win);
      }
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    void TitleWindow::Update(int numAlerts)
    {
      Dwm::DateTime  dt(Dwm::TimeValue64(time((time_t *)0), 0));
      string  str = dt.Formatted("%m/%d %H:%M");
      if (numAlerts) {
        if (16 > COLORS) {
          wattrset(_win,
                   COLOR_PAIR(ColorPairs::Pair("yellow/blue"))
                   | A_BOLD | A_UNDERLINE);
        }
        else {
          wattrset(_win,
                   COLOR_PAIR(ColorPairs::Pair("btyellow/blue"))
                    | A_BOLD | A_UNDERLINE);
        }
        string  numAlertStr = to_string(numAlerts) + " alerts";
        int     wsCount = COLS
          - (str.size() + numAlertStr.size() + strlen("mcrover"));
        int     leadingWs = wsCount / 2;
        str.append(leadingWs, ' ');
        str += "mcrover";
        str.append(wsCount - leadingWs, ' ');
        str += numAlertStr;
        mvwaddstr(_win, 0, 0, str.c_str());
      }
      else {
        wattrset(_win, COLOR_PAIR(ColorPairs::Pair("white"))|A_BOLD|A_UNDERLINE);
        int  leadingWs = (COLS / 2) - (str.size() + strlen("mcrover") / 2);
        str.append(leadingWs, ' ');
        str += "mcrover";
        int  trailingWs = COLS - (str.size() + 2);
        if (trailingWs > 0) {
          str.append(trailingWs, ' ');
        }
        mvwaddstr(_win, 0, 0, str.c_str());
        if (str.size() <= (COLS - 2)) {
          waddwstr(_win, L"\u2B50");  // 'white medium star'
        }
      }
      wclrtoeol(_win);
      wrefresh(_win);
    }

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    void TitleWindow::Resize()
    {
      wresize(_win, 1, COLS);
      mvwin(_win, 0, 0);
      return;
    }
    
  }  // namespace Mcrover

}  // namespace Dwm
