//===========================================================================
// @(#) $DwmPath: dwm/mcplex/mcrover/tags/mcrover-0.1.13/apps/qmcrover/DwmMcroverPeriodForecastWidget.cc 11932 $
// @(#) $Id: DwmMcroverPeriodForecastWidget.cc 11932 2022-04-11 02:01:48Z dwm $
//===========================================================================
//  Copyright (c) Daniel W. McRobb 2020
//  All rights reserved.
//
//  Redistribution and use in source and binary forms, with or without
//  modification, are permitted provided that the following conditions
//  are met:
//
//  1. Redistributions of source code must retain the above copyright
//     notice, this list of conditions and the following disclaimer.
//  2. Redistributions in binary form must reproduce the above copyright
//     notice, this list of conditions and the following disclaimer in the
//     documentation and/or other materials provided with the distribution.
//  3. The names of the authors and copyright holders may not be used to
//     endorse or promote products derived from this software without
//     specific prior written permission.
//
//  IN NO EVENT SHALL DANIEL W. MCROBB BE LIABLE TO ANY PARTY FOR
//  DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES,
//  INCLUDING LOST PROFITS, ARISING OUT OF THE USE OF THIS SOFTWARE,
//  EVEN IF DANIEL W. MCROBB HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH
//  DAMAGE.
//
//  THE SOFTWARE PROVIDED HEREIN IS ON AN "AS IS" BASIS, AND
//  DANIEL W. MCROBB HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT,
//  UPDATES, ENHANCEMENTS, OR MODIFICATIONS. DANIEL W. MCROBB MAKES NO
//  REPRESENTATIONS AND EXTENDS NO WARRANTIES OF ANY KIND, EITHER
//  IMPLIED OR EXPRESS, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
//  WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE,
//  OR THAT THE USE OF THIS SOFTWARE WILL NOT INFRINGE ANY PATENT,
//  TRADEMARK OR OTHER RIGHTS.
//===========================================================================

//---------------------------------------------------------------------------
//!  \file DwmMcroverPeriodForecastWidget.cc
//!  \author Daniel W. McRobb
//!  \brief NOT YET DOCUMENTED
//---------------------------------------------------------------------------

#include <QHBoxLayout>
#include <QVBoxLayout>

#include "DwmDateTime.hh"
#include "DwmSvnTag.hh"
#include "DwmMcroverPeriodForecastWidget.hh"

static const Dwm::SvnTag svntag("@(#) $DwmPath: dwm/mcplex/mcrover/tags/mcrover-0.1.13/apps/qmcrover/DwmMcroverPeriodForecastWidget.cc 11932 $");

namespace Dwm {

  namespace Mcrover {

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    PeriodForecastWidget::PeriodForecastWidget(QWidget *parent,
                                               Qt::WindowFlags f)
        : QWidget(parent, f)
    {
      // setMinimumHeight(240);
      setSizePolicy(QSizePolicy::MinimumExpanding,
                    QSizePolicy::MinimumExpanding);
      QVBoxLayout  *tempLayout = new QVBoxLayout();
      tempLayout->setAlignment(Qt::AlignTop);
      tempLayout->setSpacing(5);
      tempLayout->setSizeConstraint(QLayout::SetMinimumSize);
      
      _temperatureLabel = new QLabel("32F");
      QFont  tempFont = _temperatureLabel->font();
      tempFont.setPointSize(48);
      QFont  bigFont = tempFont;
      bigFont.setPointSize(28);
      QFont  font20pt = bigFont;
      font20pt.setPointSize(20);
      QFont  bfont20pt = font20pt;
      bfont20pt.setWeight(QFont::Bold);
      
      _temperatureLabel->setFont(tempFont);
      _temperatureLabel->setStyleSheet("color: white;");
      _windLabel = new QLabel("15 mph NNW");
      _windLabel->setFont(font20pt);
      _windLabel->setStyleSheet("color: #00FF00;");
      _windLabel->setMinimumWidth(260);
      tempLayout->addWidget(_temperatureLabel);
      tempLayout->setAlignment(_temperatureLabel, Qt::AlignTop|Qt::AlignLeft);
      tempLayout->addWidget(_windLabel);
      tempLayout->setAlignment(_windLabel, Qt::AlignTop|Qt::AlignLeft);
      tempLayout->insertStretch(-1, 1);

      QHBoxLayout  *titleLayout = new QHBoxLayout();
      titleLayout->setContentsMargins(0, 0, 10, 0);  // l, t, r, b
      titleLayout->setSizeConstraint(QLayout::SetMinimumSize);
      _nameLabel = new QLabel("Tonight");
      _nameLabel->setFont(bigFont);
      _nameLabel->setStyleSheet("color: #ffffff;");
      _shortForecastLabel = new QLabel("Isolated Snow Showers then Partly Cloudy");
      _shortForecastLabel->setFont(font20pt);
      _shortForecastLabel->setStyleSheet("color: #ffffff;");
      _shortForecastLabel->setWordWrap(true);
      _shortForecastLabel->setMinimumWidth(500);
      _shortForecastLabel->setSizePolicy(QSizePolicy::MinimumExpanding,
                                         QSizePolicy::MinimumExpanding);
      titleLayout->addWidget(_nameLabel); //, 0, Qt::AlignLeft|Qt::AlignTop);
      // titleLayout->setAlignment(_nameLabel, Qt::AlignLeft|Qt::AlignTop);
      titleLayout->addStretch(0);
      titleLayout->addWidget(_shortForecastLabel, 4, Qt::AlignRight);
      // titleLayout->setAlignment(_shortForecastLabel, Qt::AlignRight|Qt::AlignVCenter);
      
      QVBoxLayout  *forecastLayout = new QVBoxLayout();
      forecastLayout->setSizeConstraint(QLayout::SetMinimumSize);
      // forecastLayout->setAlignment(Qt::AlignLeft|Qt::AlignTop);
      forecastLayout->setContentsMargins(10, 5, 10, 5);
      forecastLayout->setSpacing(5);
      _detailedForecastLabel = new QLabel("Isolated snow showers before 7pm. Partly cloudy, with a low around 36. West wind 3 to 16 mph, with gusts as high as 33 mph.");
      _detailedForecastLabel->setFont(font20pt);
      _detailedForecastLabel->setStyleSheet("color: #f0f0f0;");
      _detailedForecastLabel->setWordWrap(true);
      _detailedForecastLabel->setSizePolicy(QSizePolicy::MinimumExpanding,
                                            QSizePolicy::MinimumExpanding);
      // _detailedForecastLabel->setAlignment(Qt::AlignLeft|Qt::AlignTop);
      _detailedForecastLabel->setMinimumWidth(1100);
      
      forecastLayout->addLayout(titleLayout);
      forecastLayout->setAlignment(titleLayout, Qt::AlignLeft|Qt::AlignTop);
      forecastLayout->addWidget(_detailedForecastLabel, 0, Qt::AlignTop);
      // forecastLayout->setAlignment(_detailedForecastLabel, Qt::AlignLeft|Qt::AlignTop);
      // forecastLayout->insertStretch(-1, 1);
      
      QHBoxLayout  *layout = new QHBoxLayout();
      layout->setAlignment(Qt::AlignLeft|Qt::AlignTop);
      layout->setSizeConstraint(QLayout::SetMinimumSize);
      layout->setSpacing(16);
      _weatherImage = new WeatherImageWidget();
      layout->addWidget(_weatherImage);
      layout->setAlignment(_weatherImage, Qt::AlignLeft|Qt::AlignTop);
      layout->addLayout(tempLayout);
      layout->setAlignment(tempLayout, Qt::AlignLeft);
      layout->addLayout(forecastLayout);
      layout->setAlignment(forecastLayout, Qt::AlignLeft|Qt::AlignTop);
      layout->setStretchFactor(forecastLayout, 1);
      setLayout(layout);
    }

#if 0
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    PeriodForecastsWidget::~PeriodForecastsWidget()
    {}
#endif
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    void
    PeriodForecastWidget::Populate(const Mcweather::PeriodForecast & forecast)
    {
      _weatherImage->Populate(forecast);
      if (! forecast.Name().empty()) {
        _nameLabel->setText(forecast.Name().c_str());
      }
      else {
        time_t  t = std::chrono::system_clock::to_time_t(forecast.StartTime());
        DateTime  dt(TimeValue64(t, 0));
        _nameLabel->setText(dt.Formatted("%a %m/%d %H:%M").c_str());
      }
      
      if (forecast.IsDayTime()) {
        setStyleSheet("background: #eeeeee;");
        _nameLabel->setStyleSheet("color: black;");
        _temperatureLabel->setStyleSheet("color: black;");
        _windLabel->setStyleSheet("color: #00A000;");
        _shortForecastLabel->setStyleSheet("color: black;");
        _detailedForecastLabel->setStyleSheet("color: black;");
      }
      else {
        setStyleSheet("background: #000000;");
        _nameLabel->setStyleSheet("color: #87d7ff;");
        _temperatureLabel->setStyleSheet("color: #87d7ff;");
        _windLabel->setStyleSheet("color: #00FF00;");
        _shortForecastLabel->setStyleSheet("color: #87d7ff;");
        _detailedForecastLabel->setStyleSheet("color: white;");
      }

      const QChar degreeChar(0260);
      // _temperatureLabel->setText(QString("%1%3%2").arg(forecast.Temperature()).arg(forecast.TemperatureUnit()).arg(degreeChar));
      _temperatureLabel->setText(QString("%1%2").arg(forecast.Temperature()).arg(degreeChar));

      std::string  wind = forecast.WindSpeed() + ' ' + forecast.WindDirection();
      _windLabel->setText(wind.c_str());
      
      _shortForecastLabel->setText(forecast.ShortForecast().c_str());
      _detailedForecastLabel->setText(forecast.DetailedForecast().c_str());
      return;
    }

#if 0
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    QSize PeriodForecastWidget::sizeHint() const
    {
      return _mySize;
    }

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    QSize PeriodForecastWidget::minimumSizeHint() const
    {
      return _mySize;
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    void PeriodForecastWidget::resizeEvent(QResizeEvent *event)
    {
      _mySize.setWidth(width());
      _mySize.setHeight(height());
    }
#endif
      
  }  // namespace Mcrover

}  // namespace Dwm
