//===========================================================================
// @(#) $DwmPath: dwm/mcplex/mcrover/tags/mcrover-0.1.13/apps/qmcrover/DwmMcroverStackedWidget.hh 11974 $
// @(#) $Id: DwmMcroverStackedWidget.hh 11974 2022-04-24 16:33:33Z dwm $
//===========================================================================
//  Copyright (c) Daniel W. McRobb 2020
//  All rights reserved.
//
//  Redistribution and use in source and binary forms, with or without
//  modification, are permitted provided that the following conditions
//  are met:
//
//  1. Redistributions of source code must retain the above copyright
//     notice, this list of conditions and the following disclaimer.
//  2. Redistributions in binary form must reproduce the above copyright
//     notice, this list of conditions and the following disclaimer in the
//     documentation and/or other materials provided with the distribution.
//  3. The names of the authors and copyright holders may not be used to
//     endorse or promote products derived from this software without
//     specific prior written permission.
//
//  IN NO EVENT SHALL DANIEL W. MCROBB BE LIABLE TO ANY PARTY FOR
//  DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES,
//  INCLUDING LOST PROFITS, ARISING OUT OF THE USE OF THIS SOFTWARE,
//  EVEN IF DANIEL W. MCROBB HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH
//  DAMAGE.
//
//  THE SOFTWARE PROVIDED HEREIN IS ON AN "AS IS" BASIS, AND
//  DANIEL W. MCROBB HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT,
//  UPDATES, ENHANCEMENTS, OR MODIFICATIONS. DANIEL W. MCROBB MAKES NO
//  REPRESENTATIONS AND EXTENDS NO WARRANTIES OF ANY KIND, EITHER
//  IMPLIED OR EXPRESS, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
//  WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE,
//  OR THAT THE USE OF THIS SOFTWARE WILL NOT INFRINGE ANY PATENT,
//  TRADEMARK OR OTHER RIGHTS.
//===========================================================================

//---------------------------------------------------------------------------
//!  \file DwmMcroverStackedWidget.hh
//!  \author Daniel W. McRobb
//!  \brief Dwm::Mcrover::StackedWidget class declaration
//---------------------------------------------------------------------------

#ifndef _DWMMCROVERSTACKEDWIDGET_HH_
#define _DWMMCROVERSTACKEDWIDGET_HH_

#include <vector>

#include <QtWidgets/QStackedWidget>

#include "DwmMcroverAlertBowl.hh"

namespace Dwm {

  namespace Mcrover {

    //------------------------------------------------------------------------
    //!  Simple stacked widget to manage pages of information (alerts,
    //!  weather forecasts, weather radar).
    //------------------------------------------------------------------------
    class StackedWidget
      : public QStackedWidget
    {
      Q_OBJECT
      
    public:
      StackedWidget(QWidget *parent = nullptr);

    public slots:
      void nextPage();
      void prevPage();
      void newAlerts(std::shared_ptr<std::vector<AlertBowl::EntryType>> alerts);
      void noAlerts();
      void pageByName(QString pageName);
      
    signals:
      void pageChanged(QWidget *);
    };
    
  }  // namespace Mcrover

}  // namespace Leoni

#endif  // _DWMMCROVERSTACKEDWIDGET_HH_
