//===========================================================================
// @(#) $DwmPath: dwm/mcplex/mcrover/tags/mcrover-0.1.13/classes/include/DwmMcroverLocalHostConfig.hh 12283 $
// @(#) $Id: DwmMcroverLocalHostConfig.hh 12283 2023-11-14 05:05:22Z dwm $
//===========================================================================
//  Copyright (c) Daniel W. McRobb 2020, 2023
//  All rights reserved.
//
//  Redistribution and use in source and binary forms, with or without
//  modification, are permitted provided that the following conditions
//  are met:
//
//  1. Redistributions of source code must retain the above copyright
//     notice, this list of conditions and the following disclaimer.
//  2. Redistributions in binary form must reproduce the above copyright
//     notice, this list of conditions and the following disclaimer in the
//     documentation and/or other materials provided with the distribution.
//  3. The names of the authors and copyright holders may not be used to
//     endorse or promote products derived from this software without
//     specific prior written permission.
//
//  IN NO EVENT SHALL DANIEL W. MCROBB BE LIABLE TO ANY PARTY FOR
//  DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES,
//  INCLUDING LOST PROFITS, ARISING OUT OF THE USE OF THIS SOFTWARE,
//  EVEN IF DANIEL W. MCROBB HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH
//  DAMAGE.
//
//  THE SOFTWARE PROVIDED HEREIN IS ON AN "AS IS" BASIS, AND
//  DANIEL W. MCROBB HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT,
//  UPDATES, ENHANCEMENTS, OR MODIFICATIONS. DANIEL W. MCROBB MAKES NO
//  REPRESENTATIONS AND EXTENDS NO WARRANTIES OF ANY KIND, EITHER
//  IMPLIED OR EXPRESS, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
//  WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE,
//  OR THAT THE USE OF THIS SOFTWARE WILL NOT INFRINGE ANY PATENT,
//  TRADEMARK OR OTHER RIGHTS.
//===========================================================================

//---------------------------------------------------------------------------
//!  \file DwmMcroverLocalHostConfig.hh
//!  \author Daniel W. McRobb
//!  \brief Dwm::Mcrover::LocalHostConfig class declaration
//---------------------------------------------------------------------------

#ifndef _DWMMCROVERLOCALHOSTCONFIG_HH_
#define _DWMMCROVERLOCALHOSTCONFIG_HH_

#include <map>
#include <string>
#include <vector>
#include <nlohmann/json.hpp>

#include "DwmIpv4Prefix.hh"

namespace Dwm {

  namespace Mcrover {

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    class LocalHostConfig
    {
    public:
      //----------------------------------------------------------------------
      //!  Default constructor.
      //----------------------------------------------------------------------
      LocalHostConfig();
      
      //----------------------------------------------------------------------
      //!  Returns a const reference to the ZFS pools to be monitored.
      //----------------------------------------------------------------------
      const std::map<std::string,uint8_t> & Zpools() const;
      
      //----------------------------------------------------------------------
      //!  Returns a mutable reference to the ZFS pools to be monitored.
      //----------------------------------------------------------------------
      std::map<std::string,uint8_t> & Zpools();
      
      //----------------------------------------------------------------------
      //!  Returns a const reference to the filesystems to be monitoried.
      //----------------------------------------------------------------------
      const std::map<std::string,uint8_t> & Filesystems() const;
      
      //----------------------------------------------------------------------
      //!  Returns a mutable reference to the filesystems to be monitoried.
      //----------------------------------------------------------------------
      std::map<std::string,uint8_t> & Filesystems();

      //----------------------------------------------------------------------
      //!  Returns a const reference to the disks to be monitored.
      //----------------------------------------------------------------------
      const std::map<std::string,std::string> & Disks() const;

      //----------------------------------------------------------------------
      //!  Returns a mutable reference to the disks to be monitored.
      //----------------------------------------------------------------------
      std::map<std::string,std::string> & Disks();

      //----------------------------------------------------------------------
      //!  Returns a const reference to the dump devices to be monitored.
      //----------------------------------------------------------------------
      const std::map<std::string,uint64_t> & Dumps() const;

      //----------------------------------------------------------------------
      //!  Returns a mutable reference to the dump devices to be monitored.
      //----------------------------------------------------------------------
      std::map<std::string,uint64_t> & Dumps();

      //----------------------------------------------------------------------
      //!  Returns a const reference to the IPv4 routes to be monitored.
      //----------------------------------------------------------------------
      const std::map<Ipv4Prefix,std::vector<Ipv4Prefix>> & Routes() const;
      
      //----------------------------------------------------------------------
      //!  Returns a mutable reference to the IPv4 routes to be monitored.
      //----------------------------------------------------------------------
      std::map<Ipv4Prefix,std::vector<Ipv4Prefix>> & Routes();
      
      //----------------------------------------------------------------------
      //!  Returns a const reference to the IPv4 guest networks to be
      //!  monitored.
      //----------------------------------------------------------------------
      const std::vector<Ipv4Prefix> & Guests() const;
      
      //----------------------------------------------------------------------
      //!  Returns a mutable reference to the IPv4 guest networks to be
      //!  monitored.
      //----------------------------------------------------------------------
      std::vector<Ipv4Prefix> & Guests();
      
      //----------------------------------------------------------------------
      //!  Returns a const reference to the IPv4 bandit networks to be
      //!  monitored.
      //----------------------------------------------------------------------
      const std::vector<Ipv4Prefix> & Bandits() const;
      
      //----------------------------------------------------------------------
      //!  Returns a mutable reference to the IPv4 bandit networks to be
      //!  monitored.
      //----------------------------------------------------------------------
      std::vector<Ipv4Prefix> & Bandits();

      //----------------------------------------------------------------------
      //!  
      //----------------------------------------------------------------------
      friend std::ostream &
      operator << (std::ostream & os, const LocalHostConfig & cfg);

      //----------------------------------------------------------------------
      //!  
      //----------------------------------------------------------------------
      nlohmann::json ToJson() const;

      //----------------------------------------------------------------------
      //!  
      //----------------------------------------------------------------------
      bool FromJson(const nlohmann::json & j);

      //----------------------------------------------------------------------
      //!  
      //----------------------------------------------------------------------
      void Clear();
      
    private:
      std::map<std::string,uint8_t>                 _zpools;
      std::map<std::string,uint8_t>                 _filesystems;
      std::map<std::string,std::string>             _disks;
      std::map<std::string,uint64_t>                _dumps;
      std::map<Ipv4Prefix,std::vector<Ipv4Prefix>>  _routes;
      std::vector<Ipv4Prefix>                       _guests;
      std::vector<Ipv4Prefix>                       _bandits;
    };
    
  }  // namespace Mcrover

}  // namespace Dwm

#endif  // _DWMMCROVERLOCALHOSTCONFIG_HH_
