//===========================================================================
// @(#) $DwmPath: dwm/mcplex/mcrover/tags/mcrover-0.1.13/classes/include/DwmMcroverMessageHeader.hh 11886 $
// @(#) $Id: DwmMcroverMessageHeader.hh 11886 2021-04-07 05:16:39Z dwm $
//===========================================================================
//  Copyright (c) Daniel W. McRobb 2020
//  All rights reserved.
//
//  Redistribution and use in source and binary forms, with or without
//  modification, are permitted provided that the following conditions
//  are met:
//
//  1. Redistributions of source code must retain the above copyright
//     notice, this list of conditions and the following disclaimer.
//  2. Redistributions in binary form must reproduce the above copyright
//     notice, this list of conditions and the following disclaimer in the
//     documentation and/or other materials provided with the distribution.
//  3. The names of the authors and copyright holders may not be used to
//     endorse or promote products derived from this software without
//     specific prior written permission.
//
//  IN NO EVENT SHALL DANIEL W. MCROBB BE LIABLE TO ANY PARTY FOR
//  DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES,
//  INCLUDING LOST PROFITS, ARISING OUT OF THE USE OF THIS SOFTWARE,
//  EVEN IF DANIEL W. MCROBB HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH
//  DAMAGE.
//
//  THE SOFTWARE PROVIDED HEREIN IS ON AN "AS IS" BASIS, AND
//  DANIEL W. MCROBB HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT,
//  UPDATES, ENHANCEMENTS, OR MODIFICATIONS. DANIEL W. MCROBB MAKES NO
//  REPRESENTATIONS AND EXTENDS NO WARRANTIES OF ANY KIND, EITHER
//  IMPLIED OR EXPRESS, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
//  WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE,
//  OR THAT THE USE OF THIS SOFTWARE WILL NOT INFRINGE ANY PATENT,
//  TRADEMARK OR OTHER RIGHTS.
//===========================================================================

//---------------------------------------------------------------------------
//!  \file DwmMcroverMessageHeader.hh
//!  \author Daniel W. McRobb
//!  \brief Dwm::Mcrover::MessageHeader class declaration
//---------------------------------------------------------------------------

#ifndef _DWMMCROVERMESSAGEHEADER_HH_
#define _DWMMCROVERMESSAGEHEADER_HH_

#include <string>
#include <tuple>

#include "DwmIpv4Address.hh"
#include "DwmDescriptorIOCapable.hh"
#include "DwmFileIOCapable.hh"
#include "DwmStreamIOCapable.hh"
#include "DwmStreamedLengthCapable.hh"

namespace Dwm {

  namespace Mcrover {

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    class MessageHeader
      : public DescriptorIOCapable, public FileIOCapable,
        public StreamIOCapable, public StreamedLengthCapable
    {
    public:
      enum MsgTypeEnum : uint8_t {
        e_typeNone        = 0,
        e_typeUpdateAlert = 1,
        e_typeDeleteAlert = 2
      };

      MessageHeader();
      MessageHeader(const std::string & pack, const Ipv4Address & member,
                    MsgTypeEnum msgType, uint32_t payloadLength);
      
      const std::string & Pack() const;
      const std::string & Pack(const std::string & pack);
      const Ipv4Address & Member() const;
      const Ipv4Address & Member(const Ipv4Address & member);
      MsgTypeEnum Type() const;
      std::string TypeName() const;
      MsgTypeEnum Type(MsgTypeEnum msgType);
      uint32_t PayloadLength() const;
      uint32_t PayloadLength(uint32_t payloadLength);

      static std::string TypeName(MsgTypeEnum msgType);
      
      std::istream & Read(std::istream & is) override;
      ssize_t Read(int fd) override;
      size_t Read(FILE *f) override;

      std::ostream & Write(std::ostream & os) const override;
      ssize_t Write(int fd) const override;
      size_t Write(FILE *f) const override;
      uint64_t StreamedLength() const override;

    private:
      std::tuple<
        std::string,   // pack
        Ipv4Address,   // pack member
        uint8_t,       // payload type
        uint32_t       // payload length
      >  _data;
    };
    
  }  // namespace Mcrover

}  // namespace Dwm

#endif  // _DWMMCROVERMESSAGEHEADER_HH_
