//===========================================================================
// @(#) $DwmPath: dwm/mcplex/mcrover/tags/mcrover-0.1.13/classes/include/DwmMcroverPackConfig.hh 12175 $
// @(#) $Id: DwmMcroverPackConfig.hh 12175 2023-06-20 03:53:12Z dwm $
//===========================================================================
//  Copyright (c) Daniel W. McRobb 2020
//  All rights reserved.
//
//  Redistribution and use in source and binary forms, with or without
//  modification, are permitted provided that the following conditions
//  are met:
//
//  1. Redistributions of source code must retain the above copyright
//     notice, this list of conditions and the following disclaimer.
//  2. Redistributions in binary form must reproduce the above copyright
//     notice, this list of conditions and the following disclaimer in the
//     documentation and/or other materials provided with the distribution.
//  3. The names of the authors and copyright holders may not be used to
//     endorse or promote products derived from this software without
//     specific prior written permission.
//
//  IN NO EVENT SHALL DANIEL W. MCROBB BE LIABLE TO ANY PARTY FOR
//  DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES,
//  INCLUDING LOST PROFITS, ARISING OUT OF THE USE OF THIS SOFTWARE,
//  EVEN IF DANIEL W. MCROBB HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH
//  DAMAGE.
//
//  THE SOFTWARE PROVIDED HEREIN IS ON AN "AS IS" BASIS, AND
//  DANIEL W. MCROBB HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT,
//  UPDATES, ENHANCEMENTS, OR MODIFICATIONS. DANIEL W. MCROBB MAKES NO
//  REPRESENTATIONS AND EXTENDS NO WARRANTIES OF ANY KIND, EITHER
//  IMPLIED OR EXPRESS, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
//  WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE,
//  OR THAT THE USE OF THIS SOFTWARE WILL NOT INFRINGE ANY PATENT,
//  TRADEMARK OR OTHER RIGHTS.
//===========================================================================

//---------------------------------------------------------------------------
//!  \file DwmMcroverPackConfig.hh
//!  \author Daniel W. McRobb
//!  \brief Dwm::Mcrover::PackConfig class declaration
//---------------------------------------------------------------------------

#ifndef _DWMMCROVERPACKCONFIG_HH_
#define _DWMMCROVERPACKCONFIG_HH_

#include <map>

#include "DwmMcroverPackMemberConfig.hh"

namespace Dwm {

  namespace Mcrover {

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    class PackConfig
    {
    public:
      //----------------------------------------------------------------------
      //!  
      //----------------------------------------------------------------------
      const std::string & PackName() const;

      //----------------------------------------------------------------------
      //!  
      //----------------------------------------------------------------------
      const std::string & PackName(const std::string & packName);

      //----------------------------------------------------------------------
      //!  
      //----------------------------------------------------------------------
      const std::map<std::string,PackMemberConfig> & Members() const;

      //----------------------------------------------------------------------
      //!  
      //----------------------------------------------------------------------
      std::map<std::string,PackMemberConfig> & Members();

      //----------------------------------------------------------------------
      //!  
      //----------------------------------------------------------------------
      void Clear();

      //----------------------------------------------------------------------
      //!  
      //----------------------------------------------------------------------
      friend std::ostream &
      operator << (std::ostream & os, const PackConfig & cfg);

      static void
      PrintMembers(std::ostream & os, int indentLevel,
                   const std::map<std::string,PackMemberConfig> & members);

      //----------------------------------------------------------------------
      //!  
      //----------------------------------------------------------------------
      nlohmann::json ToJson() const;
      
      //----------------------------------------------------------------------
      //!  
      //----------------------------------------------------------------------
      bool FromJson(const nlohmann::json & j);
      
    private:
      std::string                             _packName;
      std::map<std::string,PackMemberConfig>  _members;
    };
    
  }  // namespace Mcrover

}  // namespace Dwm

#endif  // _DWMMCROVERPACKCONFIG_HH_
