//===========================================================================
// @(#) $DwmPath: dwm/mcplex/mcrover/tags/mcrover-0.1.13/classes/src/DwmMcroverHTTPUtils.cc 11327 $
// @(#) $Id: DwmMcroverHTTPUtils.cc 11327 2020-12-04 08:48:33Z dwm $
//===========================================================================
//  Copyright (c) Daniel W. McRobb 2020
//  All rights reserved.
//
//  Redistribution and use in source and binary forms, with or without
//  modification, are permitted provided that the following conditions
//  are met:
//
//  1. Redistributions of source code must retain the above copyright
//     notice, this list of conditions and the following disclaimer.
//  2. Redistributions in binary form must reproduce the above copyright
//     notice, this list of conditions and the following disclaimer in the
//     documentation and/or other materials provided with the distribution.
//  3. The names of the authors and copyright holders may not be used to
//     endorse or promote products derived from this software without
//     specific prior written permission.
//
//  IN NO EVENT SHALL DANIEL W. MCROBB BE LIABLE TO ANY PARTY FOR
//  DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES,
//  INCLUDING LOST PROFITS, ARISING OUT OF THE USE OF THIS SOFTWARE,
//  EVEN IF DANIEL W. MCROBB HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH
//  DAMAGE.
//
//  THE SOFTWARE PROVIDED HEREIN IS ON AN "AS IS" BASIS, AND
//  DANIEL W. MCROBB HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT,
//  UPDATES, ENHANCEMENTS, OR MODIFICATIONS. DANIEL W. MCROBB MAKES NO
//  REPRESENTATIONS AND EXTENDS NO WARRANTIES OF ANY KIND, EITHER
//  IMPLIED OR EXPRESS, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
//  WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE,
//  OR THAT THE USE OF THIS SOFTWARE WILL NOT INFRINGE ANY PATENT,
//  TRADEMARK OR OTHER RIGHTS.
//===========================================================================

//---------------------------------------------------------------------------
//!  \file DwmMcroverHTTPUtils.cc
//!  \author Daniel W. McRobb
//!  \brief Dwm::Mcrover::HTTPUtils class implementation
//---------------------------------------------------------------------------

#include <chrono>
#include <map>
#include <memory>
#include <thread>

#include "DwmSvnTag.hh"
#include "DwmSysLogger.hh"
#include "DwmMcroverTargetHostConfig.hh"
#include "DwmMcroverTcp4DstAddr.hh"
#include "DwmMcroverHTTPUtils.hh"
#include "DwmMcroverHttpStatusHandler.hh"

static const Dwm::SvnTag svntag("@(#) $DwmPath: dwm/mcplex/mcrover/tags/mcrover-0.1.13/classes/src/DwmMcroverHTTPUtils.cc 11327 $");

namespace Dwm {

  namespace Mcrover {

    using namespace std;

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    bool HTTPUtils::GetAlerts(const AlertOrigin & origin,
                              const std::vector<TargetHostConfig> & hosts,
                              AlertBowl & alerts, bool clearAtEntry)
    {
      bool  rc = false;
      if (clearAtEntry) {
        alerts.Clear();
      }
      vector<HttpStatusJob>  jobs;
      for (const auto & host : hosts) {
        if (! host.WebTargets().empty()) {
          for (auto target : host.WebTargets()) {
            HttpStatusJob  job;
            job.name = host.Name();
            job.addr = host.PreferredAddress();
            job.webTarget = target;
            job.status = 0;
            jobs.push_back(job);
          }
        }
      }
      if (! jobs.empty()) {
        LoadBalancer<HttpStatusJob>  loadBalancer;
        HttpStatusHandler  statusHandler(origin, alerts);
        for (size_t i = 0; (i < jobs.size()) && (i < 16); ++i) {
          loadBalancer.AddWorker(new HttpWorker(statusHandler));
        }
        for (const auto & job : jobs) {
          loadBalancer.AddWork(job);
        }
        loadBalancer.Stop();
        Syslog(LOG_INFO, "HTTP Status load balancer done.");
      }
      return rc;
    }
    
  }  // namespace Mcrover

}  // namespace Dwm
