//===========================================================================
// @(#) $DwmPath: dwm/mcplex/mcrover/tags/mcrover-0.1.13/classes/src/DwmMcroverPackConfig.cc 12191 $
// @(#) $Id: DwmMcroverPackConfig.cc 12191 2023-06-21 15:57:12Z dwm $
//===========================================================================
//  Copyright (c) Daniel W. McRobb 2020
//  All rights reserved.
//
//  Redistribution and use in source and binary forms, with or without
//  modification, are permitted provided that the following conditions
//  are met:
//
//  1. Redistributions of source code must retain the above copyright
//     notice, this list of conditions and the following disclaimer.
//  2. Redistributions in binary form must reproduce the above copyright
//     notice, this list of conditions and the following disclaimer in the
//     documentation and/or other materials provided with the distribution.
//  3. The names of the authors and copyright holders may not be used to
//     endorse or promote products derived from this software without
//     specific prior written permission.
//
//  IN NO EVENT SHALL DANIEL W. MCROBB BE LIABLE TO ANY PARTY FOR
//  DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES,
//  INCLUDING LOST PROFITS, ARISING OUT OF THE USE OF THIS SOFTWARE,
//  EVEN IF DANIEL W. MCROBB HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH
//  DAMAGE.
//
//  THE SOFTWARE PROVIDED HEREIN IS ON AN "AS IS" BASIS, AND
//  DANIEL W. MCROBB HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT,
//  UPDATES, ENHANCEMENTS, OR MODIFICATIONS. DANIEL W. MCROBB MAKES NO
//  REPRESENTATIONS AND EXTENDS NO WARRANTIES OF ANY KIND, EITHER
//  IMPLIED OR EXPRESS, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
//  WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE,
//  OR THAT THE USE OF THIS SOFTWARE WILL NOT INFRINGE ANY PATENT,
//  TRADEMARK OR OTHER RIGHTS.
//===========================================================================

//---------------------------------------------------------------------------
//!  \file DwmMcroverPackConfig.cc
//!  \author Daniel W. McRobb
//!  \brief Dwm::Mcrover::PackConfig class implementation
//---------------------------------------------------------------------------

#include <iomanip>

#include "DwmSvnTag.hh"
#include "DwmMcroverPackConfig.hh"

static const Dwm::SvnTag svntag("@(#) $DwmPath: dwm/mcplex/mcrover/tags/mcrover-0.1.13/classes/src/DwmMcroverPackConfig.cc 12191 $");

namespace Dwm {

  namespace Mcrover {

    using namespace std;
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    const string & PackConfig::PackName() const
    {
      return _packName;
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    const string & PackConfig::PackName(const string & packName)
    {
      _packName = packName;
      return _packName;
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    const map<string,PackMemberConfig> & PackConfig::Members() const
    {
      return _members;
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    map<string,PackMemberConfig> & PackConfig::Members()
    {
      return _members;
    }

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    void PackConfig::Clear()
    {
      _packName.clear();
      _members.clear();
    }

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    void
    PackConfig::PrintMembers(ostream & os, int indentLevel,
                             const map<string,PackMemberConfig> & members)
    {
      if (! members.empty()) {
        os << setw(indentLevel) << ' ' << "members = [\n";
        auto  iter = members.begin();
        os << iter->second;
        ++iter;
        for ( ; iter != members.end(); ++iter) {
          os << ",\n" << iter->second;
        }
        os << "\n" << setw(indentLevel) << ' ' << "];\n";
      }
      return;
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    ostream & operator << (ostream & os, const PackConfig & cfg)
    {
      os << "#==============================================================="
        "=============\n"
         << "#  Our pack.  We'll pull alerts from each of our members.\n"
         << "#  NOTE: when connecting as a client to dual-stack hosts, we'll"
        " try IPv6\n"
         << "#  first.\n"
         << "#==============================================================="
        "=============\n";

      os << "pack {\n    name = \"" << cfg._packName << "\";\n";
      PackConfig::PrintMembers(os, 4, cfg._members);
#if 0
      if (! cfg._members.empty()) {
        os << "    members = [\n";
        auto  iter = cfg._members.begin();
        os << iter->second;
        ++iter;
        for ( ; iter != cfg._members.end(); ++iter) {
          os << ",\n" << iter->second;
        }
        os << "\n    ];\n";
      }
#endif
      os << "};\n\n";
      return os;
    }

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    nlohmann::json PackConfig::ToJson() const
    {
      nlohmann::json  j;
      j["packName"] = _packName;
      for (auto member : _members) {
        j["members"][member.first] = member.second.ToJson();
      }
      return j;
    }
      
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    bool PackConfig::FromJson(const nlohmann::json & j)
    {
      bool  rc = false;
      if (j.is_object()) {
        auto  it = j.find("packName");
        if ((it != j.end()) && it->is_string()) {
          _packName = it->get<string>();
          it = j.find("members");
          if ((it != j.end()) && it->is_object()) {
            auto mit = it->begin();
            for ( ; mit != it->end(); ++mit) {
              PackMemberConfig  pmc;
              if (pmc.FromJson(mit.value())) {
                _members[mit.key()] = pmc;
              }
              else {
                break;
              }
            }
            rc = (it->end() == mit);
          }
        }
      }
      return rc;
    }
    
  }  // namespace Mcrover

}  // namespace Dwm
