//===========================================================================
// @(#) $DwmPath: dwm/mcplex/mcrover/tags/mcrover-0.1.13/classes/src/DwmMcroverSMTPAlert.cc 11980 $
// @(#) $Id: DwmMcroverSMTPAlert.cc 11980 2022-04-25 02:30:15Z dwm $
//===========================================================================
//  Copyright (c) Daniel W. McRobb 2020
//  All rights reserved.
//
//  Redistribution and use in source and binary forms, with or without
//  modification, are permitted provided that the following conditions
//  are met:
//
//  1. Redistributions of source code must retain the above copyright
//     notice, this list of conditions and the following disclaimer.
//  2. Redistributions in binary form must reproduce the above copyright
//     notice, this list of conditions and the following disclaimer in the
//     documentation and/or other materials provided with the distribution.
//  3. The names of the authors and copyright holders may not be used to
//     endorse or promote products derived from this software without
//     specific prior written permission.
//
//  IN NO EVENT SHALL DANIEL W. MCROBB BE LIABLE TO ANY PARTY FOR
//  DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES,
//  INCLUDING LOST PROFITS, ARISING OUT OF THE USE OF THIS SOFTWARE,
//  EVEN IF DANIEL W. MCROBB HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH
//  DAMAGE.
//
//  THE SOFTWARE PROVIDED HEREIN IS ON AN "AS IS" BASIS, AND
//  DANIEL W. MCROBB HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT,
//  UPDATES, ENHANCEMENTS, OR MODIFICATIONS. DANIEL W. MCROBB MAKES NO
//  REPRESENTATIONS AND EXTENDS NO WARRANTIES OF ANY KIND, EITHER
//  IMPLIED OR EXPRESS, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
//  WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE,
//  OR THAT THE USE OF THIS SOFTWARE WILL NOT INFRINGE ANY PATENT,
//  TRADEMARK OR OTHER RIGHTS.
//===========================================================================

//---------------------------------------------------------------------------
//!  \file DwmMcroverSMTPAlert.cc
//!  \author Daniel W. McRobb
//!  \brief Dwm::Mcrover::SMTPAlert class implementation
//---------------------------------------------------------------------------

#include "DwmIpv4Address.hh"
#include "DwmSvnTag.hh"
#include "DwmMcroverSMTPAlert.hh"
#include "DwmMcroverUtils.hh"

static const Dwm::SvnTag svntag("@(#) $DwmPath: dwm/mcplex/mcrover/tags/mcrover-0.1.13/classes/src/DwmMcroverSMTPAlert.cc 11980 $");

namespace Dwm {

  namespace Mcrover {

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    SMTPAlert::SMTPAlert()
        : _dstAddr()
    {}
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    SMTPAlert::SMTPAlert(const TcpDstAddr & dst)
        : _dstAddr(dst)
    {}
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    const TcpDstAddr & SMTPAlert::Destination() const
    {
      return _dstAddr;
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    const TcpDstAddr & SMTPAlert::Destination(const TcpDstAddr & dst)
    {
      _dstAddr = dst;
      return _dstAddr;
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    std::string SMTPAlert::DisplayString() const
    {
      std::string  rc = Utils::GetHostName(_dstAddr.Address());
      if (rc.empty()) {
        rc = (std::string)_dstAddr.Address();
      }
      rc += ':';
      rc += std::to_string(_dstAddr.Port());
      rc += " SMTP";
      return rc;
    }

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    nlohmann::json SMTPAlert::ToJson() const
    {
      return _dstAddr.ToJson();
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    bool SMTPAlert::FromJson(const nlohmann::json & j)
    {
      return _dstAddr.FromJson(j);
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    std::istream & SMTPAlert::Read(std::istream & is)
    {
      return _dstAddr.Read(is);
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    ssize_t SMTPAlert::Read(int fd)
    {
      return _dstAddr.Read(fd);
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    size_t SMTPAlert::Read(FILE * f)
    {
      return _dstAddr.Read(f);
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    std::ostream & SMTPAlert::Write(std::ostream & os) const
    {
      return _dstAddr.Write(os);
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    ssize_t SMTPAlert::Write(int fd) const
    {
      return _dstAddr.Write(fd);
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    size_t SMTPAlert::Write(FILE *f) const
    {
      return _dstAddr.Write(f);
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    uint64_t SMTPAlert::StreamedLength() const
    {
      return _dstAddr.StreamedLength();
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    bool SMTPAlert::operator == (const SMTPAlert & alert) const
    {
      return (_dstAddr == alert._dstAddr);
    }
    
  }  // namespace Mcrover

}  // namespace Dwm
