//===========================================================================
// @(#) $DwmPath: dwm/mcplex/mcrover/tags/mcrover-0.1.13/classes/src/DwmMcroverTcp4ConnAlert.cc 11886 $
// @(#) $Id: DwmMcroverTcp4ConnAlert.cc 11886 2021-04-07 05:16:39Z dwm $
//===========================================================================
//  Copyright (c) Daniel W. McRobb 2020
//  All rights reserved.
//
//  Redistribution and use in source and binary forms, with or without
//  modification, are permitted provided that the following conditions
//  are met:
//
//  1. Redistributions of source code must retain the above copyright
//     notice, this list of conditions and the following disclaimer.
//  2. Redistributions in binary form must reproduce the above copyright
//     notice, this list of conditions and the following disclaimer in the
//     documentation and/or other materials provided with the distribution.
//  3. The names of the authors and copyright holders may not be used to
//     endorse or promote products derived from this software without
//     specific prior written permission.
//
//  IN NO EVENT SHALL DANIEL W. MCROBB BE LIABLE TO ANY PARTY FOR
//  DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES,
//  INCLUDING LOST PROFITS, ARISING OUT OF THE USE OF THIS SOFTWARE,
//  EVEN IF DANIEL W. MCROBB HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH
//  DAMAGE.
//
//  THE SOFTWARE PROVIDED HEREIN IS ON AN "AS IS" BASIS, AND
//  DANIEL W. MCROBB HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT,
//  UPDATES, ENHANCEMENTS, OR MODIFICATIONS. DANIEL W. MCROBB MAKES NO
//  REPRESENTATIONS AND EXTENDS NO WARRANTIES OF ANY KIND, EITHER
//  IMPLIED OR EXPRESS, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
//  WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE,
//  OR THAT THE USE OF THIS SOFTWARE WILL NOT INFRINGE ANY PATENT,
//  TRADEMARK OR OTHER RIGHTS.
//===========================================================================

//---------------------------------------------------------------------------
//!  \file DwmMcroverTcp4ConnAlert.cc
//!  \author Daniel W. McRobb
//!  \brief Dwm::Mcrover::Tcp4ConnAlert class implementation
//---------------------------------------------------------------------------

#include "DwmIpv4Address.hh"
#include "DwmSvnTag.hh"
#include "DwmMcroverTcp4ConnAlert.hh"
#include "DwmMcroverUtils.hh"

static const Dwm::SvnTag svntag("@(#) $DwmPath: dwm/mcplex/mcrover/tags/mcrover-0.1.13/classes/src/DwmMcroverTcp4ConnAlert.cc 11886 $");

namespace Dwm {

  namespace Mcrover {

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    Tcp4ConnAlert::Tcp4ConnAlert()
        : _dstAddr()
    {}
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    Tcp4ConnAlert::Tcp4ConnAlert(const Tcp4DstAddr & dst)
        : _dstAddr(dst)
    {}
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    const Tcp4DstAddr & Tcp4ConnAlert::Destination() const
    {
      return _dstAddr;
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    const Tcp4DstAddr &
    Tcp4ConnAlert::Destination(const Tcp4DstAddr & dst)
    {
      _dstAddr = dst;
      return _dstAddr;
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    std::string Tcp4ConnAlert::DisplayString() const
    {
      std::string  rc;
      if (! _dstAddr.Name().empty()) {
        rc = _dstAddr.Name();
      }
      else {
        rc += (std::string)Ipv4Address(_dstAddr.Address());
      }
      rc += ':';
      rc += std::to_string(_dstAddr.Port());
      rc += " TCP";
      return rc;
    }

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    nlohmann::json Tcp4ConnAlert::ToJson() const
    {
      return _dstAddr.ToJson();
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    bool Tcp4ConnAlert::FromJson(const nlohmann::json & j)
    {
      return _dstAddr.FromJson(j);
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    std::istream & Tcp4ConnAlert::Read(std::istream & is)
    {
      return _dstAddr.Read(is);
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    ssize_t Tcp4ConnAlert::Read(int fd)
    {
      return _dstAddr.Read(fd);
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    size_t Tcp4ConnAlert::Read(FILE * f)
    {
      return _dstAddr.Read(f);
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    std::ostream & Tcp4ConnAlert::Write(std::ostream & os) const
    {
      return _dstAddr.Write(os);
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    ssize_t Tcp4ConnAlert::Write(int fd) const
    {
      return _dstAddr.Write(fd);
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    size_t Tcp4ConnAlert::Write(FILE *f) const
    {
      return _dstAddr.Write(f);
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    uint64_t Tcp4ConnAlert::StreamedLength() const
    {
      return _dstAddr.StreamedLength();
    }
    
    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    bool Tcp4ConnAlert::operator == (const Tcp4ConnAlert & alert) const
    {
      return (_dstAddr == alert._dstAddr);
    }

    //------------------------------------------------------------------------
    //!  
    //------------------------------------------------------------------------
    bool
    Tcp4ConnAlert::operator < (const Tcp4ConnAlert & alert) const
    {
      return (_dstAddr < alert._dstAddr);
    }
    
    
  }  // namespace Mcrover

}  // namespace Dwm
