//===========================================================================
// @(#) $DwmPath: dwm/mcplex/mcrover/tags/mcrover-0.1.13/classes/tests/TestRPCProgramId.cc 10997 $
// @(#) $Id: TestRPCProgramId.cc 10997 2020-08-27 05:34:16Z dwm $
//===========================================================================
//  Copyright (c) Daniel W. McRobb 2020
//  All rights reserved.
//
//  Redistribution and use in source and binary forms, with or without
//  modification, are permitted provided that the following conditions
//  are met:
//
//  1. Redistributions of source code must retain the above copyright
//     notice, this list of conditions and the following disclaimer.
//  2. Redistributions in binary form must reproduce the above copyright
//     notice, this list of conditions and the following disclaimer in the
//     documentation and/or other materials provided with the distribution.
//  3. The names of the authors and copyright holders may not be used to
//     endorse or promote products derived from this software without
//     specific prior written permission.
//
//  IN NO EVENT SHALL DANIEL W. MCROBB BE LIABLE TO ANY PARTY FOR
//  DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES,
//  INCLUDING LOST PROFITS, ARISING OUT OF THE USE OF THIS SOFTWARE,
//  EVEN IF DANIEL W. MCROBB HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH
//  DAMAGE.
//
//  THE SOFTWARE PROVIDED HEREIN IS ON AN "AS IS" BASIS, AND
//  DANIEL W. MCROBB HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT,
//  UPDATES, ENHANCEMENTS, OR MODIFICATIONS. DANIEL W. MCROBB MAKES NO
//  REPRESENTATIONS AND EXTENDS NO WARRANTIES OF ANY KIND, EITHER
//  IMPLIED OR EXPRESS, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
//  WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE,
//  OR THAT THE USE OF THIS SOFTWARE WILL NOT INFRINGE ANY PATENT,
//  TRADEMARK OR OTHER RIGHTS.
//===========================================================================

//---------------------------------------------------------------------------
//!  \file TestRPCProgramId.hh
//!  \author Daniel W. McRobb
//!  \brief NOT YET DOCUMENTED
//---------------------------------------------------------------------------

extern "C" {
  #include <fcntl.h>
  #include <unistd.h>
}

#include <iostream>
#include <sstream>

#include "DwmUnitAssert.hh"
#include "DwmMcroverRPCProgramId.hh"
#include "DwmMcroverUnitTestUtils.hh"

using namespace std;
using namespace Dwm;

#define MY_TESTIOFILENAME "TestRPCProgramId.tmp"

//----------------------------------------------------------------------------
//!  
//----------------------------------------------------------------------------
static void TestAccessors()
{
  Mcrover::RPCProgramId   progid(100000, "rpcbind", 6, 3);
  UnitAssert(progid.Number() == 100000);
  UnitAssert(progid.Name() == "rpcbind");
  UnitAssert(progid.Protocol() == 6);
  UnitAssert(progid.Version() == 3);

  UnitAssert(progid.Number(100005) == 100005);
  UnitAssert(progid.Number() == 100005);
  UnitAssert(progid.Name("mountd") == "mountd");
  UnitAssert(progid.Name() == "mountd");
  UnitAssert(progid.Protocol(17) == 17);
  UnitAssert(progid.Protocol() == 17);
  UnitAssert(progid.Version(1) == 1);
  UnitAssert(progid.Version() == 1);
  
  return;
}

//----------------------------------------------------------------------------
//!  
//----------------------------------------------------------------------------
static void TestBasicIO()
{
  Mcrover::RPCProgramId   progid(100000, "rpcbind", 6, 3);
  Mcrover::UnitTestUtils::TestBasicStreamIO(progid);
  Mcrover::UnitTestUtils::TestBasicFileIO(progid, MY_TESTIOFILENAME);
  Mcrover::UnitTestUtils::TestBasicDescriptorIO(progid, MY_TESTIOFILENAME);
  return;
}

//----------------------------------------------------------------------------
//!  
//----------------------------------------------------------------------------
static void TestBasicJSON()
{
  Mcrover::RPCProgramId   progid(100000, "rpcbind", 6, 3);
  Mcrover::UnitTestUtils::TestBasicJSON(progid);
}
      
//----------------------------------------------------------------------------
//!  
//----------------------------------------------------------------------------
int main(int argc, char *argv[])
{
  TestAccessors();
  TestBasicIO();
  TestBasicJSON();
  
  if (Assertions::Total().Failed()) {
    Assertions::Print(cerr, true);
  }
  else {
    cout << Assertions::Total() << " passed" << endl;
  }
  
}
